% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_logreg.R
\name{p_logreg}
\alias{p_logreg}
\title{Poolwise Logistic Regression}
\usage{
p_logreg(g, y, x, method = "glm", prev = NULL, samp_y1y0 = NULL,
  estimate_var = TRUE, ...)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector with poolwise \code{Y} values, coded 0 if all members
are controls and 1 if all members are cases.}

\item{x}{Numeric matrix with poolwise \strong{\code{X}} values, with one row
for each pool. Can be a vector if there is only 1 predictor.}

\item{method}{Character string specifying method to use for estimation.
Choices are "glm" for \code{\link[stats]{glm}} function and \code{"ml"} for
maximum likelihood.}

\item{prev}{Numeric value specifying disease prevalence, allowing
for valid estimation of the intercept with case-control sampling. Can specify
\code{samp_y1y0} instead if sampling rates are known.}

\item{samp_y1y0}{Numeric vector of length 2 specifying sampling probabilities
for cases and controls, allowing for valid estimation of the intercept with
case-control sampling. Can specify \code{prev} instead if it's easier.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Fitted \code{\link[stats]{glm}} object (if \code{method = "glm"}) or
returned \code{\link[stats]{nlminb}} object (if \code{method = "ml"}).
\item Akaike information criterion (AIC).
}
}
\description{
Fit homogeneous-pools logistic regression model described by Weinberg &
Umbach (1999).
}
\examples{
# Load dataset containing (Y, Xtilde, C) values for pools of size 1, 2, and 3
data(pdat1)

# Estimate log-OR for Xtilde and Y adjusted for C
fit <- p_logreg(g = pdat1$g, y = pdat1$allcases, x = pdat1[, c("xtilde", "c")])
fit$theta.hat


}
\references{
Weinberg, C.R. and Umbach, D.M. (1999) "Using pooled exposure assessment to
improve efficiency in case-control studies." \emph{Biometrics} \strong{55}:
718--726.

Weinberg, C.R. and Umbach, D.M. (2014) "Correction to 'Using pooled exposure
assessment to improve efficiency in case-control studies' by Clarice R.
Weinberg and David M. Umbach; 55, 718--726, September 1999."
\emph{Biometrics} \strong{70}: 1061.
}
