% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{run_scrm}
\alias{run_scrm}
\title{Simulate a single population}
\usage{
run_scrm(nDip, nloci, theta = 10)
}
\arguments{
\item{nDip}{an integer representing the total number of diploid individuals
to simulate. Note that \code{\link[scrm:scrm]{scrm::scrm()}} actually simulates haplotypes, so the
number of simulated haplotypes is double of this.}

\item{nloci}{is an integer that represents how many independent loci should
be simulated.}

\item{theta}{a value for the mutation rate assuming theta = 4Nu, where u is
the neutral mutation rate per locus.}
}
\value{
a list with genotypes. Each entry of the list corresponds to a
different locus. For each locus, the genotypes are in a matrix, with each
row representing a different individual and each column a different site.
}
\description{
Simulates the evolution of biological sequences for a single population with
variable theta values.
}
\examples{
run_scrm(nDip = 100, nloci = 10)
run_scrm(nDip = 100, nloci = 10, theta = 5)

}
