% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measles.R
\docType{data}
\name{measles}
\alias{measles}
\alias{LondonYorke}
\alias{ewmeas}
\alias{ewcitmeas}
\title{Historical childhood disease incidence data}
\description{
\code{LondonYorke} is a data frame containing the monthly number of reported cases of chickenpox, measles, and mumps from two American cities (Baltimore and New York) in the mid-20th century (1928--1972).

\code{ewmeas} and \code{ewcitmeas} are data frames containing weekly reported cases of measles in England and Wales.
\code{ewmeas} records the total measles reports for the whole country, 1948--1966.
One questionable data point has been replaced with an NA.
\code{ewcitmeas} records the incidence in seven English cities 1948--1987.
These data were kindly provided by Ben Bolker, who writes:
\dQuote{Most of these data have been manually entered from published records by various people, and are prone to errors at several levels.
All data are provided as is; use at your own risk.}
}
\examples{

plot(cases~time,data=LondonYorke,subset=disease=="measles",type='n',main="measles",bty='l')
lines(cases~time,data=LondonYorke,subset=disease=="measles"&town=="Baltimore",col="red")
lines(cases~time,data=LondonYorke,subset=disease=="measles"&town=="New York",col="blue")
legend("topright",legend=c("Baltimore","New York"),lty=1,col=c("red","blue"),bty='n')

plot(
     cases~time,
     data=LondonYorke,
     subset=disease=="chickenpox"&town=="New York",
     type='l',col="blue",main="chickenpox, New York",
     bty='l'
    )

plot(
     cases~time,
     data=LondonYorke,
     subset=disease=="mumps"&town=="New York",
     type='l',col="blue",main="mumps, New York",
     bty='l'
    )

plot(reports~time,data=ewmeas,type='l')

plot(reports~date,data=ewcitmeas,subset=city=="Liverpool",type='l')

}
\references{
\London1973
}
\seealso{
Other datasets: 
\code{\link{blowflies}},
\code{\link{bsflu}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{parus}}

Other pomp examples: 
\code{\link{blowflies}},
\code{\link{bsflu}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{gompertz}()},
\code{\link{ou2}()},
\code{\link{parus}},
\code{\link{pomp_examples}},
\code{\link{ricker}()},
\code{\link{rw2}()},
\code{\link{sir_models}},
\code{\link{verhulst}()}
}
\concept{datasets}
\concept{pomp examples}
\keyword{datasets}
