% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{create_phased_maplist}
\alias{create_phased_maplist}
\title{Create a phased homologue map list using the original dosages}
\usage{
create_phased_maplist(maplist, dosage_matrix.conv, dosage_matrix.orig = NULL,
  remove_markers = NULL, N_linkages = 2, lower_bound = 0.05, ploidy = 4,
  ploidy2 = NULL, marker_assignment.1, marker_assignment.2, parent1 = "P1",
  parent2 = "P2", original_coding = FALSE, log = NULL, verbose = TRUE)
}
\arguments{
\item{maplist}{A list of maps. In the first column marker names and in the second their position.}

\item{dosage_matrix.conv}{Matrix of marker dosage scores with markers in rows and individuals in columns. Note that dosages must be
in converted form, i.e. after having run the \code{\link{convert_marker_dosages}} function. Errors may result otherwise.}

\item{dosage_matrix.orig}{Optional, by default \code{NULL}.The unconverted dosages (i.e. raw dosage data before using
the \code{\link{convert_marker_dosages}} function). Required if \code{original_coding} is \code{TRUE}.}

\item{remove_markers}{Optional vector of marker names to remove from the maps. Default is \code{NULL}.}

\item{N_linkages}{Number of significant linkages (as defined in \code{\link{homologue_lg_assignment}}) required for high-confidence linkage group assignment.}

\item{lower_bound}{Numeric. Lower bound for the rate at which homologue linkages (fraction of total for that marker) are recognised.}

\item{ploidy}{Integer. Ploidy of the organism.}

\item{ploidy2}{Optional integer, by default \code{NULL}. Ploidy of parent 2, if different from parent 1.}

\item{marker_assignment.1}{A marker assignment matrix for parent 1 with markernames as rownames and at least containing the column \code{"Assigned_LG"}.}

\item{marker_assignment.2}{A marker assignment matrix for parent 2 with markernames as rownames and at least containing the column \code{"Assigned_LG"}.}

\item{parent1}{character vector with names of the samples of parent 1}

\item{parent2}{character vector with names of the samples of parent 2}

\item{original_coding}{Logical. Should the phased map use the unconverted dosage coding or not?}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}

\item{verbose}{Logical, by default \code{TRUE}. Should unphased markers be recorded?}
}
\description{
\code{create_phased_maplist} is a function for creating a phased maplist, using
integrated map positions and original marker dosages.
}
\examples{
data("integrated.maplist", "screened_data3", "marker_assignments_P1","marker_assignments_P2")
create_phased_maplist(integrated.maplist,
                     dosage_matrix.conv = screened_data3,
                     marker_assignment.1=marker_assignments_P1,
                     marker_assignment.2=marker_assignments_P2)
}
