% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\docType{methods}
\name{count}
\alias{count}
\alias{count-method}
\alias{count,partition-method}
\alias{count,partition_bundle-method}
\alias{count,character-method}
\alias{count,vector-method}
\alias{count,Corpus-method}
\title{Get counts.}
\usage{
count(.Object, ...)

\S4method{count}{partition}(.Object, query = NULL, cqp = is.cqp,
  breakdown = FALSE, decode = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  mc = getOption("polmineR.cores"), verbose = TRUE, progress = FALSE, ...)

\S4method{count}{partition_bundle}(.Object, query = NULL, cqp = FALSE,
  p_attribute = NULL, freq = FALSE, total = TRUE, mc = FALSE,
  progress = TRUE, verbose = FALSE, ...)

\S4method{count}{character}(.Object, query = NULL, cqp = is.cqp,
  p_attribute = getOption("polmineR.p_attribute"), breakdown = FALSE,
  sort = FALSE, decode = TRUE, verbose = TRUE, ...)

\S4method{count}{vector}(.Object, corpus, p_attribute, ...)

\S4method{count}{Corpus}(.Object, query = NULL, p_attribute)
}
\arguments{
\item{.Object}{A \code{partition} or \code{partition_bundle}, or a length-one
character vector providing the name of a corpus.}

\item{...}{Further arguments.}

\item{query}{A character vector (one or multiple terms), CQP syntax can be
used.}

\item{cqp}{Either logical (\code{TRUE} if query is a CQP query), or a
function to check whether query is a CQP query or not (defaults to is.query
auxiliary function).}

\item{breakdown}{Logical, whether to report number of occurrences for
different matches for a query.}

\item{decode}{Logical, whether to turn token ids into decoded strings (only
if query is NULL).}

\item{p_attribute}{The p-attribute(s) to use.}

\item{mc}{Logical, whether to use multicore (defaults to \code{FALSE}).}

\item{verbose}{Logical, whether to be verbose.}

\item{progress}{Logical, whether to show progress bar.}

\item{freq}{Logical, if \code{FALSE}, counts will be reported, if TRUE,
(relative) frequencies are added to table.}

\item{total}{Defaults to \code{FALSE}, if \code{TRUE}, the total value of
counts (column named 'TOTAL') will be amended to the \code{data.table} that
is returned.}

\item{sort}{Logical, whether to sort table with counts (in stat slot).}

\item{corpus}{The name of a CWB corpus.}
}
\value{
A \code{data.table} if argument query is used, a \code{count}-object,
  if query is \code{NULL} and \code{.Object} is a character vector (referring 
  to a corpus) or a \code{partition}, a \code{count_bundle}-object, if \code{.Object}
  is a \code{partition_bundle}.
}
\description{
Count all tokens, or number of occurrences of a query (CQP syntax may be
used), or matches for the query.
}
\details{
If .Object is a \code{partiton_bundle}, the data.table returned will have the
queries in the columns, and as many rows as there are in the
\code{partition_bundle}.

If .Object is a length-one character vector and query is NULL, the count is
performed for the whole partition.

If \code{breakdown} is \code{TRUE} and one query is supplied, the function
returns a frequency breakdown of the results of the query. If several queries
are supplied, frequencies for the individual queries are retrieved.
}
\examples{
use("polmineR")
debates <- partition("GERMAPARLMINI", date = ".*", regex=TRUE)
count(debates, query = "Arbeit") # get frequencies for one token
count(debates, c("Arbeit", "Freizeit", "Zukunft")) # get frequencies for multiple tokens
  
count("GERMAPARLMINI", query = c("Migration", "Integration"), p_attribute = "word")

debates <- partition_bundle(
  "GERMAPARLMINI", s_attribute = "date", values = NULL,
  regex = TRUE, mc = FALSE, verbose = FALSE
)
y <- count(debates, query = "Arbeit", p_attribute = "word")
y <- count(debates, query = c("Arbeit", "Migration", "Zukunft"), p_attribute = "word")
  
count("GERMAPARLMINI", '"Integration.*"', breakdown = TRUE)

P <- partition("GERMAPARLMINI", date = "2009-11-11")
count(P, '"Integration.*"', breakdown = TRUE)
}
\references{
Baker, Paul (2006): \emph{Using Corpora in Discourse Analysis}. London: continuum, p. 47-69 (ch. 3).
}
\seealso{
For a metadata-based breakdown of counts
(i.e. tabulation by s-attributes), see \code{dispersion}.

count
}
