% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpos.R
\docType{methods}
\name{cpos}
\alias{cpos}
\alias{cpos,character-method}
\alias{cpos,partition-method}
\alias{cpos,tempcorpus-method}
\alias{cpos,matrix-method}
\alias{cpos,hits-method}
\title{Get corpus positions for a query or queries.}
\usage{
cpos(.Object, ...)

\S4method{cpos}{character}(.Object, query,
  p_attribute = getOption("polmineR.p_attribute"), cqp = is.cqp,
  check = TRUE, encoding = NULL, verbose = TRUE, ...)

\S4method{cpos}{partition}(.Object, query, cqp = is.cqp, check = TRUE,
  p_attribute = NULL, verbose = TRUE, ...)

\S4method{cpos}{tempcorpus}(.Object, query, shift = TRUE)

\S4method{cpos}{matrix}(.Object)

\S4method{cpos}{hits}(.Object)
}
\arguments{
\item{.Object}{A \code{character} vector indicating a CWB corpus, a
\code{partition} object, a \code{tempcorpus} object, or a
\code{matrix} with corpus positions.}

\item{...}{Used for reasons of backwards compatibility to
process arguments that have been renamed (e.g. \code{pAttribute}).}

\item{query}{A \code{character} vector providing one or multiple queries
(token or CQP query)}

\item{p_attribute}{The p-attribute to search. Needs to be stated only if query
is not a CQP query. Defaults to \code{NULL}.}

\item{cqp}{Either logical (\code{TRUE} if query is a CQP query), or a function to
check whether query is a CQP query or not (defaults to \code{is.cqp} auxiliary
function).}

\item{check}{A \code{logical} value, whether to check validity of CQP query
using \code{check_cqp_query}.}

\item{encoding}{The encoding of the corpus (if NULL, the
encoding stated in the registry file of the corpus will be used),}

\item{verbose}{A \code{logical} value, whether to show messages.}

\item{shift}{logical, if true, the cpos resulting from the query performed on
the tempcorpus will be shifted so that they match the positions of the
corpus from which the tempcorpus was generated}
}
\value{
Unless \code{.Object} is a \code{matrix}, the return value is a
  \code{matrix} with two columns.  The first column reports the left/starting
  corpus positions (cpos) of the hits obtained. The second column reports the
  right/ending corpus positions of the respective hit. The number of rows is
  the number of hits. If there are no hits, a \code{NULL} object is returned.
}
\description{
Get matches for a query in a CQP corpus, optionally using the CQP syntax of the
Corpus Workbench (CWB).
}
\details{
If the cpos-method is applied on \code{"character"}, \code{"partition"}, or
\code{"tempcorpus"} object, the result is a two-column matrix with the 
regions (start end end corpus positions of the matches) for a query. CQP
syntax can be used. The encoding of the query is adjusted to conform to the
encoding of the CWB corpus.

If the cpos-method is called on a \code{matrix} object,  the cpos
matrix is unfolded, the return value is an integer vector with the individual
corpus positions. Equally, if \code{.Object} is a \code{hits} object,
an integer vector is returned with the individual corpus positions.
}
