% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{subset_id}
\alias{subset_id}
\title{Subset Policy Data on ID}
\usage{
subset_id(object, id)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}

\item{id}{character vectors of IDs.}
}
\value{
Object of class \link{policy_data}.
}
\description{
\code{subset_id} returns a policy data object containing the given IDs.
}
\examples{
library("polle")
### Single stage:
d <- sim_single_stage(5e2, seed=1)
# constructing policy_data object:
pd <- policy_data(d, action="A", covariates=list("Z", "B", "L"), utility="U")
pd

# getting the observation IDs:
get_id(pd)[1:10]

# subsetting on IDs:
pdsub <- subset_id(pd, id = 250:500)
pdsub
get_id(pdsub)[1:10]
}
