% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_learn.R
\name{policy_learn}
\alias{policy_learn}
\alias{policy_object}
\alias{print.policy_object}
\alias{print.policy_learn}
\title{Create Policy Learner}
\usage{
policy_learn(
  type = "rql",
  alpha = 0,
  L = 1,
  save_cross_fit_models = FALSE,
  future_args = list(future.seed = TRUE),
  full_history = FALSE,
  qv_models = NULL,
  policy_vars = NULL,
  depth = 2,
  split.step = 1,
  min.node.size = 1,
  hybrid = FALSE,
  search.depth = 2
)

\method{print}{policy_object}(x, ...)

\method{print}{policy_learn}(x, ...)
}
\arguments{
\item{type}{Type of policy learner method:
\itemize{
\item{} \code{"rql"}: Realistic Quality/Q-learning.
\item{} \code{"rqvl"}: Realistic V-restricted (doubly robust) Q-learning.
\item{} \code{"ptl"}: Policy Tree Learning.
}}

\item{alpha}{Probability threshold for determining realistic actions.}

\item{L}{(only used if \code{type = "rqvl"} or \code{type = "ptl"}) Number of folds for
cross-fitting.}

\item{save_cross_fit_models}{If \code{TRUE}, the cross-fitted models will be saved.}

\item{future_args}{Arguments passed to \code{\link[future.apply:future_apply]{future.apply::future_apply()}}.}

\item{full_history}{If \code{TRUE}, the full
history is used to fit each QV-model/policy tree. If FALSE, the single stage/
"Markov type" history is used to fit each QV-model/policy tree.}

\item{qv_models}{(only used if \code{type = "rqvl"}) V-restricted Q-models created
by \code{\link[=q_glm]{q_glm()}}, \code{\link[=q_rf]{q_rf()}}, \code{\link[=q_sl]{q_sl()}} or similar functions.}

\item{policy_vars}{(only used if \code{type = "ptl"}) Character vector/string or
list of character vectors/strings. Variable names used to construct a
V-restricted policy tree. The names must be a subset of the history variable
names, see \code{\link[=get_history_names]{get_history_names()}}.}

\item{depth}{(only used if \code{type = "ptl"}) Numeric or numeric vector.
The depth of the fitted policy tree for each stage, see \code{\link[=policy_tree]{policy_tree()}}.}

\item{split.step}{(only used if \code{type = "ptl"}) Numeric or numeric vector.
The number of possible splits to consider when performing policy tree search
at each stage, see \code{\link[=policy_tree]{policy_tree()}}.}

\item{min.node.size}{(only used if \code{type = "ptl"}) Numeric or numeric vector.
The smallest terminal node size permitted at each stage, see \code{\link[=policy_tree]{policy_tree()}}.}

\item{hybrid}{(only used if \code{type = "ptl"}) If \code{TRUE}, \code{\link[=hybrid_policy_tree]{hybrid_policy_tree()}} is
used to fit a policy tree.}

\item{search.depth}{(only used if \code{type = "ptl"} and \code{hybrid = TRUE})
Numeric or numeric vector. Depth to look ahead when splitting at each stage.}

\item{x}{Object of class "policy_object" or "policy_learn".}

\item{...}{Additional arguments passed to print.}
}
\value{
Function of inherited class \code{"policy_learn"}.
Evaluating the function on a \link{policy_data} object returns an object of
class \link{policy_object}. A policy object is a list containing all or
some of the following elements:
\item{\code{q_functions}}{Fitted Q-functions. Object of class "nuisance_functions".}
\item{\code{g_functions}}{Fitted g-functions. Object of class "nuisance_functions".}
\item{\code{action_set}}{Sorted character vector describing the action set, i.e.,
the possible actions at each stage.}
\item{\code{alpha}}{Numeric. Probability threshold to determine realistic actions.}
\item{\code{K}}{Integer. Maximal number of stages.}
\item{\code{qv_functions}}{(only if \code{type = "rqvl"}) Fitted V-restricted
Q-functions. Contains a fitted model for each stage and action.}
\item{\code{ptl_objects}}{(only if \code{type = "ptl"}) Fitted V-restricted
policy trees. Contains a \link{policy_tree} for each stage.}
\item{\code{ptl_designs}}{(only if \code{type = "ptl"}) Specification of the
V-restricted design matrix for each stage}
}
\description{
\code{policy_learn()} is used to specify a policy learning method (Q-learning,
V-restricted (doubly robust) Q-learning and V-restricted policy tree
learning). Evaluating the policy learner returns a policy object.
}
\details{
For references on V-restricted Q-learning (\code{type = "rqvl"}), see \doi{10.1515/ijb-2015-0052}.
For references on policy tree learning (\code{type = "ptl"}), see \doi{10.48550/arXiv.1810.04778}.
}
\section{S3 generics}{

The following S3 generic functions are available for an object of
class "policy_object":
\itemize{
\item{\code{\link[=get_g_functions]{get_g_functions()}}}{ Extract the fitted g-functions.}
\item{\code{\link[=get_q_functions]{get_q_functions()}}}{ Extract the fitted Q-functions.}
\item{\code{\link[=get_policy]{get_policy()}}}{ Extract the fitted policy object.}
\item{\code{\link[=get_policy_functions]{get_policy_functions()}}}{ Extract the fitted policy function for
a given stage.}
\item{\code{\link[=get_policy_actions]{get_policy_actions()}}}{ Extract the (fitted) policy actions.}
}
}

\examples{
library("polle")
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = c("BB"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

### V-restricted (Doubly Robust) Q-learning

# specifying the learner:
pl <- policy_learn(type = "rqvl",
                   qv_models = list(q_glm(formula = ~ C_1 + BB),
                                    q_glm(formula = ~ L_1 + BB)),
                   full_history = TRUE)

# evaluating the learned policy
pe <- policy_eval(policy_data = pd,
                  policy_learn = pl,
                  q_models = q_glm(),
                  g_models = g_glm())
pe
# getting the policy object:
po <- get_policy_object(pe)
# inspecting the fitted QV-model for each action strata at stage 1:
po$qv_functions$stage_1
head(get_policy(pe)(pd))
}
\seealso{
\code{\link[=policy_eval]{policy_eval()}}
}
