% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericModel.R
\name{GenericModel}
\alias{GenericModel}
\title{R6 class representing a generic model.}
\description{
\code{\link[R6:R6Class]{R6}} class with generic (abstract) functionality for toolset
models, including model attribute get and set methods that resolve attribute scope
(\emph{public}, \emph{active}, \emph{attached}), attribute aliases, attribute
attachment, and error and warning message attributes.
}
\examples{
model1 <- GenericModel$new(model_attributes = c("a", "b", "c"),
                           attribute_aliases = list(A = "a"),
                           params = list(a = 1, b = 2), c = 3)
# Get/set attributes
model1$get_attribute_names()
model1$set_attributes(d = 4)
model1$get_attributes()
model1$get_attribute("A")
model1$get_attribute("B")
model1$get_attribute_aliases() # all attribute names
# New cloning
model2 <- model1$new_clone(e = 5)
model2$get_attributes()
model2$modelattributes
model2$attribute_aliases

}
\section{Super class}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{GenericModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GenericModel-new}{\code{GenericModel$new()}}
\item \href{#method-GenericModel-new_clone}{\code{GenericModel$new_clone()}}
\item \href{#method-GenericModel-get_attribute_names}{\code{GenericModel$get_attribute_names()}}
\item \href{#method-GenericModel-get_attributes}{\code{GenericModel$get_attributes()}}
\item \href{#method-GenericModel-get_attribute}{\code{GenericModel$get_attribute()}}
\item \href{#method-GenericModel-get_attribute_aliases}{\code{GenericModel$get_attribute_aliases()}}
\item \href{#method-GenericModel-set_attributes}{\code{GenericModel$set_attributes()}}
\item \href{#method-GenericModel-clone}{\code{GenericModel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets given attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$new(
  model_attributes = NULL,
  attribute_aliases = NULL,
  params = list(),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{params}}{Parameters passed via a list.}

\item{\code{...}}{Parameters passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-new_clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-new_clone}{}}}
\subsection{Method \code{new_clone()}}{
Creates a new (re-initialized) object of the current (inherited) object class with optionally passed parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$new_clone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via the inherited class constructor (defined in initialize and run via new).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New object of the current (inherited) class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-get_attribute_names"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-get_attribute_names}{}}}
\subsection{Method \code{get_attribute_names()}}{
Returns an array of all attribute names including public and private model attributes, as well as attached attributes, error and warning messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$get_attribute_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Array of all attribute names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Returns a list of values for selected attributes or attribute aliases (when array of parameter names provided) or all attributes (when no params).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$get_attributes(params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Array of attribute names to return (all when NULL).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selected or all attributes values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-get_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-get_attribute}{}}}
\subsection{Method \code{get_attribute()}}{
Returns the value of an attribute via character name or attribute alias.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$get_attribute(param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{Character string name of the attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Attribute value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-get_attribute_aliases"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-get_attribute_aliases}{}}}
\subsection{Method \code{get_attribute_aliases()}}{
Returns an array of attribute names and aliases for specified or all attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$get_attribute_aliases(params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Array of attribute names for names/aliases to return (all when NULL).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Array of selected or all attribute names and aliases.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-set_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-set_attributes}{}}}
\subsection{Method \code{set_attributes()}}{
Sets given attributes (optionally via alias names) individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$set_attributes(params = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{List of parameters/attributes.}

\item{\code{...}}{Parameters/attributes passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenericModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
