% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_blq.R
\name{estimate_lloq}
\alias{estimate_lloq}
\title{Estimate the lower limit of quantification (LLOQ) from a vector}
\usage{
estimate_lloq(x)
}
\arguments{
\item{x}{The numeric vector to use for estimation of the LLOQ}
}
\value{
The lowest, nonzero value from \code{x}.  If all are \code{NA} or
  zero, 1 is returned, and a warning is issued.
}
\description{
Nonnegative values are considered to be above the LLOQ. \code{NA} values are
ignored.
}
\examples{
estimate_lloq(c(NA, 0, 2, 5))
}
\seealso{
Other BLQ Transformation: 
\code{\link{blq_trans}()},
\code{\link{breaks_blq_general}()},
\code{\link{ftrans_blq_linear}()},
\code{\link{itrans_blq_linear}()},
\code{\link{label_blq}()}
}
\concept{BLQ Transformation}
