% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.lm.R
\name{pmml.lm}
\alias{pmml.lm}
\title{Generate the PMML representation for an lm object from the package \pkg{stats}.}
\usage{
\method{pmml}{lm}(
  model,
  model_name = "lm_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Linear Regression Model",
  copyright = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{model}{An lm object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{weights}{The weights used for building the model.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{lm} object.
}
\description{
Generate the PMML representation for an lm object from the package \pkg{stats}.
}
\details{
The resulting PMML representation will not encode interaction
terms. Currently, only numeric regression is supported.
}
\examples{

fit <- lm(Sepal.Length ~ ., data = iris)
fit_pmml <- pmml(fit)
}
\references{
\href{http://stat.ethz.ch/R-manual/R-devel/library/stats/html/lm.html}{R project: Fitting Linear Models}
}
\author{
Rajarshi Guha
}
