% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.omicsData.R
\name{as.pepData}
\alias{as.pepData}
\title{Create pmartR Object of Class pepData}
\usage{
as.pepData(
  e_data,
  f_data,
  e_meta = NULL,
  edata_cname,
  fdata_cname,
  emeta_cname = NULL,
  techrep_cname = NULL,
  ...
)
}
\arguments{
\item{e_data}{a \eqn{p \times n + 1} data frame of expression data, where
\eqn{p} is the number of peptides observed and \eqn{n} is the number of
samples (an additional peptide identifier/name column should also be
present somewhere in the data frame). Each row corresponds to data for one
peptide. One column specifying a unique identifier for each peptide (row)
must be present.}

\item{f_data}{a data frame with \eqn{n} rows. Each row corresponds to a
sample with one column giving the unique sample identifiers found in e_data
column names and other columns providing qualitative and/or quantitative
traits of each sample.}

\item{e_meta}{an optional data frame with at least \eqn{p} rows. Each row
corresponds to a peptide with one column giving peptide names (must be
named the same as the column in \code{e_data}) and other columns giving biomolecule
meta information (e.g. mappings of peptides to proteins).}

\item{edata_cname}{character string specifying the name of the column
containing the peptide identifiers in \code{e_data} and \code{e_meta} (if
applicable).}

\item{fdata_cname}{character string specifying the name of the column
containing the sample identifiers in \code{f_data}.}

\item{emeta_cname}{character string specifying the name of the column
containing the protein identifiers (or other mapping variable) in
\code{e_meta} (if applicable). Defaults to NULL. Can be the same as edata_cname, if desired. If \code{e_meta} is NULL,
then either do not specify \code{emeta_cname} or specify it as NULL.}

\item{techrep_cname}{character string specifying the name of the column in
\code{f_data} that specifies which samples are technical replicates. This column is used to
collapse the data when \code{combine_techreps} is called on this object.
Defaults to NULL (no technical replicates).}

\item{...}{further arguments}
}
\value{
Object of class pepData
}
\description{
Converts several data frames of (unlabeled or global, as opposed to labeled) peptide data to an
object of the class 'pepData'. Objects of the class 'pepData' are lists with
two obligatory components, \code{e_data} and \code{f_data}. An optional list
component, \code{e_meta}, is used if analysis or visualization at other levels
(e.g. protein) is also desired.
}
\details{
Objects of class 'pepData' contain some attributes that are
  referenced by downstream functions. These attributes can be changed from
  their default value by manual specification. A list of these attributes as
  well as their default values are as follows: \tabular{ll}{ data_scale \tab
  Scale of the data provided in \code{e_data}. Acceptable values are 'log2',
  'log10', 'log', and 'abundance', which indicate data is log base 2, base
  10, natural log, or raw abundance, respectively. Default is
  'abundance'. \cr \tab \cr is_normalized \tab A logical argument, specifying
  whether the data has been normalized or not. Default value is FALSE. \cr
  \tab \cr norm_info \tab Default value is an empty list, which will be
  populated with a single named element \code{is_normalized = is_normalized}.
  When a normalization is applied to the data, this becomes populated with a
  list containing the normalization function, normalization subset and subset
  parameters, the location and scale parameters used to normalize the data,
  and the location and scale parameters used to backtransform the data (if
  applicable). \cr \tab \cr data_types \tab Character string describing the type of data, most commonly used for lipidomic data (lipidData objects) or NMR data (nmrData objects) but available for other data classes as well. Default value is NULL. \cr } Computed
  values included in the \code{data_info} attribute are as follows:
  \tabular{ll}{ num_edata \tab The number of unique \code{edata_cname}
  entries.\cr \tab \cr num_miss_obs \tab The number of missing
  observations.\cr \tab \cr num_emeta \tab The number of unique
  \code{emeta_cname} entries. \cr \tab \cr prop_missing \tab The proportion
  of \code{e_data} values that are NA. \cr \tab \cr num_samps \tab The number
  of samples that make up the columns of \code{e_data}.\cr \tab \cr meta_info
  \tab A logical argument, specifying whether \code{e_meta} is provided.\cr
  \tab \cr }
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mypepData <- as.pepData(
  e_data = pep_edata,
  e_meta = pep_emeta,
  f_data = pep_fdata,
  edata_cname = "Peptide",
  fdata_cname = "SampleID",
  emeta_cname = "RazorProtein"
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{as.proData}}

\code{\link{as.isobaricpepData}}
}
\author{
Kelly Stratton, Lisa Bramer
}
