
<!-- README.md is generated from README.Rmd. Please edit that file -->

# plsmod

<!-- badges: start -->

[![R build
status](https://github.com/tidymodels/plsmod/workflows/R-CMD-check/badge.svg)](https://github.com/tidymodels/plsmod/actions)
[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![CRAN
status](https://www.r-pkg.org/badges/version/plsmod)](https://CRAN.R-project.org/package=plsmod)
[![Codecov test
coverage](https://codecov.io/gh/tidymodels/plsmod/branch/main/graph/badge.svg)](https://app.codecov.io/gh/tidymodels/plsmod?branch=main)
[![R-CMD-check](https://github.com/tidymodels/plsmod/workflows/R-CMD-check/badge.svg)](https://github.com/tidymodels/plsmod/actions)
<!-- badges: end -->

This package is a helper package for
[parsnip](https://parsnip.tidymodels.org) that enables linear projection
models (such as partial least squares, PLS) in the tidymodels
infrastructure.

## Installation

You can install the released version of plsmod from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("plsmod")
```

And the development version from [GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("tidymodels/plsmod")
```

## Available Engines

The plsmod package provides engines for the models in the following
table.

| model | engine   | mode           |
|:------|:---------|:---------------|
| pls   | mixOmics | classification |
| pls   | mixOmics | regression     |

## Contributing

This project is released with a [Contributor Code of
Conduct](https://www.contributor-covenant.org/version/2/0/CODE_OF_CONDUCT.html).
By contributing to this project, you agree to abide by its terms.

-   For questions and discussions about tidymodels packages, modeling,
    and machine learning, please [post on RStudio
    Community](https://community.rstudio.com/new-topic?category_id=15&tags=tidymodels,question).

-   If you think you have encountered a bug, please [submit an
    issue](https://github.com/tidymodels/plsmod/issues).

-   Either way, learn how to create and share a
    [reprex](https://reprex.tidyverse.org/articles/articles/learn-reprex.html)
    (a minimal, reproducible example), to clearly communicate about your
    code.

-   Check out further details on [contributing guidelines for tidymodels
    packages](https://www.tidymodels.org/contribute/) and [how to get
    help](https://www.tidymodels.org/help/).
