% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetplot.R
\name{prepare_upset_data}
\alias{prepare_upset_data}
\title{Prepare data for Upset plot}
\usage{
prepare_upset_data(
  data,
  in_form = "auto",
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL,
  specific = TRUE
)
}
\arguments{
\item{data}{A data frame or a list or an UpsetPlotData object.}

\item{in_form}{A character string indicating the datatype of the input data.
Possible values are "long", "wide", "list", "upset" or "auto".
"long" indicates the data is in long format.
"wide" indicates the data is in wide format.
"list" indicates the data is a list.
"upset" indicates the data is a UpsetPlotData object.
"auto" indicates the function will detect the datatype of the input data.

A long format data would look like:
\preformatted{
group_by id_by
A        a1
A        a2
B        a1
B        a3
...
}

A wide format data would look like:
\preformatted{
A    B
TRUE TRUE
TRUE FALSE
FALSE TRUE
...
}

A list format data would look like:
\preformatted{
list(A = c("a1", "a2"), B = c("a1", "a3"))
}

An UpsetPlotData object is generated by prepare_update_data() would look like:
\preformatted{
group_by
--------
list("A")  # a2
list("B")  # a3
list(c("A", "B"))  # a1
...
}}

\item{group_by}{A character string specifying the column name of the data frame to group the data.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by},
if multiple columns are provided and the in_form is "long".}

\item{id_by}{A character string specifying the column name of the data frame to identify the instances.
Required when \code{group_by} is a single column and data is a data frame.}

\item{specific}{A logical value to show the specific intersections only.
ggVennDiagram, by default, only return the specific subsets of a region. However,
sometimes, we want to show all the overlapping items for two or more sets.
See \url{https://github.com/gaospecial/ggVennDiagram/issues/64} for more details.}
}
\value{
A UpsetPlotData object
}
\description{
Prepare data for Upset plot
}
\keyword{internal}
