\name{pred.GP}
\alias{pred.GP}
\alias{pred.CGP}
\alias{pred.ConstGP}
\title{
  Prediction for GPs
}
\description{
  Prediction on a per-particle basis for Gaussian process (GP)
  regression, classification, or combined unknown constraint
  models
}
\usage{
pred.GP(XX, Zt, prior, Y = NULL, quants = FALSE, Sigma = FALSE,
        sub = 1:Zt$t)
pred.CGP(XX, Zt, prior, mcreps = 100, cs = NULL)
pred.ConstGP(XX, Zt, prior, quants = TRUE) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{XX}{
    \code{matrix} or \code{data.frame} containing (a design of)
    predictive locations where \code{ncol(XX) = ncol(X)}, on which the
    data were trained and particle \code{Zt} thus obtained
}
\item{Zt}{
  the particle describing model parameters and sufficient statistics
  that determines the predictive distribution
}
\item{prior}{
  prior parameters passed from \code{\link{PL}} generated by one of
  the prior functions, e.g., \code{\link{prior.GP}}
}
\item{Y}{
  not for external use; used internally by CGP and ConstGP internal
  routines
}
\item{quants}{
  a scalar \code{logical} indicating
  if predictive quantiles should be
  are desired
}
\item{Sigma}{
  a scalar \code{logical} indicating if the full predictive
  variance-covariance matrix is desired; typically only used internally
  by CGP and ConstGP
}
\item{sub}{
  not for external used; used internally by CGP and ConstGP internal
  routines
}
\item{mcreps}{
  number of Monte Carlo iterations used in CGP prediction, integrating
  over the latent real-valued \code{Y} variables at the \code{XX}
  locations
}
\item{cs}{
  indicates a class label at which the predictive probability is
  desired; the entire probability distribution over all class labels
  will be provided if not specified
}
}
\details{
  For \code{pred.GP} the predictive mean (and quantiles if \code{quants
    = TRUE} is provided.  For \code{pred.CGP} the predictive
  distribution over the class labels is provided, unless only one
  class (\code{cs}) is desired.  \code{pred.ConstGP} is a combination
  of the \code{pred.GP} and \code{pred.CGP} methods
    
  It is suggested that this function is used in as an argument to
  \code{\link{papply}} to obtain many predictions - one for each
  particle in a cloud - which are combined into a
  \code{\link{data.frame}}
    
  Some of the function arguments aren't meant to
  be specified by the user, but are rather there to facilitate usage as a
  subroutine inside other \code{\link{PL}} functions, such as
  \code{\link{lpredprob.GP}} and others
}
\value{
  A single-row \code{\link{data.frame}} is returned with the desired
  predictive; these rows are automatically combined when used with
  \code{\link{papply}}
}
\references{
  Gramacy, R. and Polson, N. (2010).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Tech. Rep. arXiv:0909.5262, University of Cambridge.

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  \url{http://www.statslab.cam.ac.uk/~bobby/plgp.html}
}
\author{
  Robert B. Gramacy, \email{bobby@statslab.cam.ac.uk}
}

\seealso{
  \code{\link{papply}}, \code{\link{PL}}, \code{\link{lpredprob.GP}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}

\keyword{models}
\keyword{regression}
\keyword{classif}
\keyword{methods}
