% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\alias{FFPK}
\alias{pbtk1cpt_model}
\alias{pbpk_apap_model}
\title{Example PK Model for Sensitivity Analysis}
\usage{
FFPK(params, time, dose = 1)

pbtk1cpt_model()

pbpk_apap_model()
}
\arguments{
\item{params}{a numeric vector to define the input parameter value.}

\item{time}{a numeric vector to define the given time point(s).}

\item{dose}{a numeric value to define the given dose in flip-flop model.}
}
\description{
The example PK model that were used in sensitivity testing.
Three examples are included: Flip-flop pharmacokinetic model,
one-compartment toxicokinetic model from \pkg{httk} (Pearce et al. 2017),
and acetaminophen pharmacokinetic model (Zurlinden et al. 2016).
}
\section{Functions}{
\itemize{
\item \code{pbtk1cpt_model}: Download pbtk1cpt.model file.

\item \code{pbpk_apap_model}: Download pbpk_apap.model file.
}}

\examples{
params <- c(F = 0.9, KA = 1.2, KE = 0.2, V = 1.5)
t <- seq(0, 12, 0.1)
C <-FFPK(params = params, time = t)
plot(t, C, type = "l", xlab = "time", ylab = "concentration")

}
\references{
Pearce, R. G., Setzer, R. W., Strope, C. L., Wambaugh, J. F., & Sipes, N. S. (2017).
httk: R package for high-throughput toxicokinetics.
\emph{Journal of Statistical Software}, 79(4), 1-26.

Zurlinden, T. J., & Reisfeld, B. (2016).
Physiologically based modeling of the pharmacokinetics of acetaminophen and
its major metabolites in humans using a Bayesian population approach.
\emph{European journal of drug metabolism and pharmacokinetics}, 41(3), 267-280.
}
