% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_hhline.R
\name{sprinkle_hhline}
\alias{sprinkle_hhline}
\alias{sprinkle_hhline.default}
\alias{sprinkle_hhline.dust_list}
\title{Change the hhline Property in a Dust Table}
\source{
\url{https://www.ctan.org/pkg/hhline?lang=en}
}
\usage{
sprinkle_hhline(x, hhline = getOption("pixie_hhline", FALSE), ...)

\method{sprinkle_hhline}{default}(x, hhline = getOption("pixie_hhline",
  FALSE), ...)

\method{sprinkle_hhline}{dust_list}(x, hhline = getOption("pixie_hhline",
  FALSE), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{hhline}{\code{logical(1)}. When \code{TRUE}, the LaTeX hhline package
will be used for cell borderes.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The \code{hhline} property controls the appearance of 
  cell borders in LaTeX tables.  There is a known limitation in the 
  LaTeX \code{colortbl} package where cell borders can be hidden if
  the cell has a background color.  If using both cell borders and
  background colors, it is recommended that you use the \code{hhline}
  property to make cell borders appear as desired.
}
\details{
When \code{hhline = TRUE}, borders will be solid; dashed and dotted
  borders are unsupported by hhline.

This property has no effect on non-LaTeX output.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{hhline} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{hhline} is not logical and length 1.
}
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}

