% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sim_yule_twin_tree_fun.R
\name{create_sim_yule_twin_tree_fun}
\alias{create_sim_yule_twin_tree_fun}
\title{Create a partially evaluated function to to \link{sim_yule_twin_tree}.}
\usage{
create_sim_yule_twin_tree_fun(method = "random_tree", n_replicates = 10000)
}
\arguments{
\item{method}{determines how to create the twin tree
\itemize{
    \item 'random_tree' just produces a random tree;
    \item 'max_clade_cred' simulates \code{n_replicates} trees and
      uses \link[phangorn]{maxCladeCred} to create a consensus tree;
    \item 'max_likelihood' simulates \code{n_replicates} trees
     and selects the most likely;
  }}

\item{n_replicates}{number of replicas to evaluate in order to create the
twin tree}
}
\value{
a function
}
\description{
The function \link{sim_yule_twin_tree} simulates a twin tree
using the Yule speciation model.
}
\examples{

f <- create_sim_yule_twin_tree_fun()
phylo_in <- ape::read.tree(text = "((A:1, B:1):1, C:2);")
f(phylo_in)
}
\seealso{
Use \link{get_sim_bd_twin_tree_fun} to get a partially
evaluated function to produce a Birth-Death tree.
Use \link{create_copy_twtr_from_true_fun} to get a
function to simply copy the tree
}
\author{
Richèl J.C. Bilderbeek
}
