% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_experiments.R
\name{select_experiments}
\alias{select_experiments}
\title{Select the experiments to do a Bayesian inference with.}
\usage{
select_experiments(
  experiments = list(create_test_experiment()),
  marg_liks = NULL,
  verbose = FALSE
)
}
\arguments{
\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}

\item{marg_liks}{a data frame with marginal likelihoods/evidences.
A test data frame can be created by \link{create_test_marg_liks}}

\item{verbose}{if TRUE, show more output}
}
\value{
a list of inference models
}
\description{
Select the experiments to do a Bayesian inference with.
}
\examples{
if (beautier::is_on_ci()) {

  evidences <- create_test_marg_liks(
    site_models = list(beautier::create_jc69_site_model()),
    clock_models = list(beautier::create_strict_clock_model()),
    tree_priors = list(
      beautier::create_yule_tree_prior(), 
      beautier::create_bd_tree_prior()
    )
  )
  evidences$weight <- c(0.9, 0.1) # in favor of Yule

  if (rappdirs::app_dir()$os != "win") {
    experiment_yule <- create_test_cand_experiment()
    experiment_bd <- create_test_cand_experiment()
    experiment_bd$inference_model$tree_prior <- 
      beautier::create_bd_tree_prior()
    experiment_yule$beast2_options <- experiment_bd$beast2_options
    experiment_yule$inference_model$mcmc <- experiment_bd$inference_model$mcmc
    experiment_yule$errors_filename <- experiment_bd$errors_filename
    experiments <- list(experiment_yule, experiment_bd)

    # Select the experiment.
    # In this case, select the candidate experiment with the highest evidence
    select_experiments(
      experiments = experiments,
      marg_liks = evidences
    )
  }

}
}
\seealso{
Use \link{check_experiments} to check if an object
  is a list of experiments
}
\author{
Richèl J.C. Bilderbeek
}
