% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sim_twal_with_same_n_mutation_fun.R
\name{get_sim_twal_same_n_muts_fun}
\alias{get_sim_twal_same_n_muts_fun}
\title{of mutations as the true alignment has.}
\usage{
get_sim_twal_same_n_muts_fun(
  mutation_rate = 1,
  site_model = beautier::create_jc69_site_model(),
  max_n_tries = 100,
  verbose = FALSE
)
}
\arguments{
\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}

\item{max_n_tries}{maximum number of tries before giving up}

\item{verbose}{if TRUE, show more output}
}
\value{
the function \link{sim_twal_with_same_n_mutation}
}
\description{
The twin alignment is simulated from the twin tree.
The number of mutations it will have is counted by comparing
it to the root sequence.
The twin alignment will have an equal amount of mutations
as the true alignment.
}
\details{
This is an adapter function
(see \url{https://en.wikipedia.org/wiki/Adapter_pattern}),
with the purpose of passing \link{check_sim_twal_fun},
by being a function with the function arguments \code{twin_phylogeny}
and \code{true_alignment}.
}
\seealso{
See \link{check_sim_twal_fun} to the the other
functions to simulate a twin alignment.
Use \link{sim_twin_alignment} to use this function to
create a twin alignment.
}
