% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_pir_outs.R
\name{collect_pir_outs}
\alias{collect_pir_outs}
\title{Collect the results of multiple \link{pirouette} runs}
\usage{
collect_pir_outs(pir_outs)
}
\arguments{
\item{pir_outs}{the output of \link{pir_runs}}
}
\value{
a single \link{pir_run} output as produced by a single pir run.
}
\description{
Collect the results of multiple \link{pirouette} runs
}
\examples{

if (beautier::is_on_ci() && beastier::is_beast2_installed()) {

  pir_paramses <- list()
  pir_paramses[[1]] <- pirouette::create_test_pir_params()
  pir_paramses[[2]] <- pirouette::create_test_pir_params()

  phylogenies <- list()
  phylogenies[[1]] <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
  phylogenies[[2]] <- ape::read.tree(text = "((A:1, B:1):2, C:3);")

  pir_outs <- pir_runs(
    phylogenies = phylogenies,
    pir_paramses = pir_paramses
  )
  pir_out_total <- collect_pir_outs(pir_outs)
}
}
\author{
Giovanni Laudanno
}
