% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sim_tral_with_std_nsm_fun.R
\name{get_sim_tral_with_std_nsm_fun}
\alias{get_sim_tral_with_std_nsm_fun}
\title{Get a function to simulate the true alignment with,
that uses a standard site model.}
\usage{
get_sim_tral_with_std_nsm_fun(
  mutation_rate = 1,
  site_model = beautier::create_jc69_site_model()
)
}
\arguments{
\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}
}
\value{
a function
}
\description{
Get a function to simulate the true alignment with,
that uses a standard site model.
}
\examples{

f <- get_sim_tral_with_std_nsm_fun(
  mutation_rate = 0.1
)
check_sim_tral_fun(f)

alignment_params <- create_test_alignment_params(
  sim_tral_fun = f,
  root_sequence = "acgt",
)
true_alignment <- sim_true_alignment(
  true_phylogeny = ape::read.tree(text = "((A:1, B:1):1, C:2);"),
  alignment_params = alignment_params
)
}
