% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_unary_func_throw_error}
\alias{check_unary_func_throw_error}
\title{Validate ml_pipeline_builder transform method is a unary function}
\usage{
check_unary_func_throw_error(func, func_name)
}
\arguments{
\item{func}{A \code{ml_pipeline_builder} method.}

\item{func_name}{The name of the \code{ml_pipeline_builder} method.}
}
\description{
Helper function that checks if a \code{ml_pipeline_builder} method is unary function (if it
isn't a NULL returning function), and if it isn't, throws an error that is customised with the
method function name.
}
\examples{
\dontrun{
transform_method <- function(df) df
check_unary_func_throw_error(transform_method, "transform_method")
# NULL
}
}

