% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_max.R
\name{pin_est_core}
\alias{pin_est_core}
\title{Optimization in PIN models}
\usage{
pin_est_core(numbuys = NULL, numsells = NULL, factorization = c("Lin_Ke",
  "EHO"), init_vals = NULL, lower = rep(0, 5), upper = c(1, 1, rep(Inf,
  3)), num_best_res = 1, only_converged = TRUE)
}
\arguments{
\item{numbuys}{\emph{numeric} vector of daily buys}

\item{numsells}{\emph{numeric} vector of daily sells}

\item{factorization}{\emph{character} factorization of likelihood function: either 'EHO' or 'Lin_Ke', defaults to: 'Lin_Ke'}

\item{init_vals}{\emph{numeric} matrix of initial values: either generated by \code{\link{initial_vals}} or
user-defined matrix with five columns for which colnames must consist of:
\code{alpha}, \code{delta}, \code{epsilon_b}, \code{epsilon_s}, \code{mu}}

\item{lower}{\emph{numeric} lower bounds for optimization, must have length of 5}

\item{upper}{\emph{numeric} upper bounds for optimization, must have length of 5}

\item{num_best_res}{Number of optimization runs for which results should be returned, either numeric or 'all',
only relevant if \code{init_vals} = 'Grid', defaults to 1}

\item{only_converged}{\emph{logical} Return only results for which the likelihood converged?
Defaults to \code{TRUE}}
}
\value{
If \code{num_best_res} = 1, a list with seven elements is returned:
\describe{
\item{Results}{Matrix containing the parameter estimates as well as their estimated standard errors,
 t-values and p-values.}
 \item{ll}{Value of likelihood function returned by \code{nlminb}}
 \item{pin}{Estimated probability of informed trading}
 \item{conv}{Convergence code for nlminb optimization}
 \item{message}{Convergence message returned by the nlminb optimizer}
 \item{iterations}{Number of iterations until convergence of nlminb optimizer}
 \item{init_vals}{Vector of initial values}
 }

 If \code{num_best_res} > 1, a named list of lists is returned. Each component of the outer list
 is again a list structured as shown above.
 Naming scheme for the outer list is 'Best1',..., 'Best\code{num_best_res}'.
}
\description{
Core function for optimization routines
}
\details{
Grants the most control over optimization procedure.
User-friendly wrappers for estimation with trading data of arbitrary length and quarterly data
are implemented with \code{\link{pin_est}} and \code{\link{qpin}}, respectively.
\code{\link{nlminb}} function in the \pkg{stats} package is used for maximization. 
Vectors for \code{numbuys} and \code{numsells} need to have same length.
}
\examples{
# Loading simulated data for frequently traded stock

data("BSfrequent")

# Generate several matrices of initial values utilizing all methods implemented

inits_grid <- initial_vals(numbuys = BSfrequent[,"Buys"],
                           numsells = BSfrequent[,"Sells"],
                           method = "Grid")

inits_hac <- initial_vals(numbuys = BSfrequent[,"Buys"],
                          numsells = BSfrequent[,"Sells"],
                          method = "HAC")

inits_hac_ref <- initial_vals(numbuys = BSfrequent[,"Buys"], 
                              numsells = BSfrequent[,"Sells"],
                              method = "HAC_Ref")

# Optimization with different matrices of initial values

pin_core_grid <- pin_est_core(numbuys = BSfrequent[,"Buys"], 
                              numsells = BSfrequent[,"Sells"],
                              factorization = "Lin_Ke", init_vals = inits_grid,
                              lower = rep(0,5), upper = c(1,1, rep(Inf,3)),
                              num_best_res = 5)

pin_core_hac <- pin_est_core(numbuys = BSfrequent[,"Buys"], 
                             numsells = BSfrequent[,"Sells"],
                             factorization = "Lin_Ke", init_vals = inits_hac,
                             lower = rep(0,5), upper = c(1,1, rep(Inf,3)))

pin_core_hac_ref <- pin_est_core(numbuys = BSfrequent[,"Buys"], 
                                 numsells = BSfrequent[,"Sells"],
                                 factorization = "Lin_Ke", init_vals = inits_hac_ref,
                                 lower = rep(0,5), upper = c(1,1, rep(Inf,3)))
}
\references{
Easley, David et al. (2002) \cr
Is Information Risk a Determinant of Asset Returns? \cr
\emph{The Journal of Finance}, Volume 57, Number 5, pp. 2185 - 2221 \cr
\doi{10.1111/1540-6261.00493}

Easley, David et al. (1996) \cr
Liquidity, Information, and Infrequently Traded Stocks\cr
\emph{The Journal of Finance}, Volume 51, Number 4, pp. 1405 - 1436 \cr
\doi{10.1111/j.1540-6261.1996.tb04074.x}

Easley, David et al. (2010) \cr
Factoring Information into Returns \cr
\emph{Journal of Financial and Quantitative Analysis}, Volume 45, Issue 2, pp. 293 - 309
\doi{10.1017/S0022109010000074}

Ersan, Oguz and Alici, Asli (2016) \cr
An unbiased computation methodology for estimating the probability of informed trading (PIN) \cr
\emph{Journal of International Financial Markets, Institutions and Money}, Volume 43, pp. 74 - 94 \cr
\doi{10.1016/j.intfin.2016.04.001}

Gan, Quan et al. (2015) \cr
A faster estimation method for the probability of informed trading
using hierarchical agglomerative clustering \cr
\emph{Quantitative Finance}, Volume 15, Issue 11, pp. 1805 - 1821 \cr
\doi{10.1080/14697688.2015.1023336}

Lin, Hsiou-Wei William and Ke, Wen-Chyan (2011) \cr
A computing bias in estimating the probability of informed trading \cr
\emph{Journal of Financial Markets}, Volume 14, Issue 4, pp. 625 - 640 \cr
\doi{10.1016/j.finmar.2011.03.001}

Yan, Yuxing and Zhang, Shaojun (2012) \cr
An improved estimation method and empirical properties of the probability of informed trading \cr
\emph{Journal of Banking & Finance}, Volume 36, Issue 2, pp. 454 - 467 \cr
\doi{10.1016/j.jbankfin.2011.08.003}
}
\seealso{
\code{\link{nlminb}},
         \code{\link{initial_vals}}
         \code{\link{pin_est}}
         \code{\link{qpin}}
}

