% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-hts.r
\name{pima_hts}
\alias{pima_hts}
\alias{htsdl}
\title{Higgins-Thompson-Spiegelhalter prediction interval with the Dersimonian-Laird estimator for \eqn{\hat{\tau}}}
\usage{
pima_hts(y, sigma, alpha = 0.05)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
the prediction limits \eqn{\hat{c}_l} (\code{lpi}) and \eqn{\hat{c}_u} (\code{upi}),
the confidence limits \eqn{\hat{\mu}_l} (\code{lci}) and \eqn{\hat{\mu}_u} (\code{uci}),
the DL estimator for \eqn{\hat{\tau}}
(\code{tau2h}).
}
\description{
A subroutine for the original HTS PI
}
\examples{
data(sbp, package = "pimeta")
pimeta::pima_hts(sbp$y, sbp$sigmak)
# $muhat
# [1] -0.3340597
# $lbpi
# [1] -0.7597777
# $ubpi
# [1] 0.09165839
# $tau2h
# [1] 0.02824971
}
\references{
Higgins, J. P. T, Thompson, S. G., Spiegelhalter, D. J. (2009).
A re-evaluation of random-effects meta-analysis.
\emph{J R Stat Soc Ser A Stat Soc.}
\strong{172}(1): 137-159.
}
