% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-boot.r
\name{pima_boot}
\alias{pima_boot}
\alias{bootPI}
\title{A parametric bootstrap prediction interval (Nagashima et al., 2018)}
\usage{
pima_boot(y, sigma, alpha = 0.05, B = 25000, maxit1 = 1e+05,
  eps = 10^(-10), lower = 0, upper = 1000, maxit2 = 1000,
  tol = .Machine$double.eps^0.25, rnd = NULL)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}

\item{B}{the number of bootstrap samples}

\item{maxit1}{the maximum number of iteration for the exact distribution function of \eqn{Q}}

\item{eps}{the desired level of accuracy for the exact distribution function of \eqn{Q}}

\item{lower}{the lower limit of random numbers of \eqn{\tau^2}}

\item{upper}{the lower upper of random numbers of \eqn{\tau^2}}

\item{maxit2}{the maximum number of iteration for numerical inversions}

\item{tol}{the desired level of accuracy for numerical inversions}

\item{rnd}{a vector of random numbers from the exact distribution of \eqn{\tau^2}}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
and the lower and upper prediction limits \eqn{\hat{c}_l} (\code{lbpi}) and \eqn{\hat{c}_u} (\code{ubpi}).
}
\description{
A subroutine for the parametric bootstrap PI
}
\examples{
data(sbp, package = "pimeta")
set.seed(20161102)
\donttest{pimeta::pima_boot(sbp$y, sbp$sigmak, B = 50000)}
# Average treatment effect [95\%PI]:
# -0.334 [-0.877, 0.225]
# Average treatment effect [95\%CI]:
# -0.334 [-0.566, -0.098]
# Heterogeneity variance (tau^2):
# 0.028
}
\references{
Nagashima, K., Noma, H., and Furukawa, T. A. (2018).
Prediction intervals for random-effects meta-analysis:
a confidence distribution approach.
\emph{Stat Methods Med Res}.
\emph{In press}.
\url{https://doi.org/10.1177/0962280218773520}.
}
