% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_piece.R
\name{animate_piece}
\alias{animate_piece}
\title{Animate board game pieces}
\usage{
animate_piece(
  dfs,
  file = "animation.gif",
  ...,
  annotate = TRUE,
  .f = piecepackr::grid.piece,
  cfg = getOption("piecepackr.cfg", NULL),
  envir = getOption("piecepackr.envir", game_systems("sans")),
  n_transitions = 0L,
  n_pauses = 1L,
  fps = n_transitions + n_pauses,
  width = NULL,
  height = NULL,
  ppi = NULL,
  new_device = TRUE,
  annotation_scale = NULL
)
}
\arguments{
\item{dfs}{A list of data frames of game data to plot.}

\item{file}{Filename to save animation unless \code{NULL}
in which case it uses the current graphics device.}

\item{...}{Arguments to \code{pmap_piece}}

\item{annotate}{If \code{TRUE} or \code{"algebraic"} annotate the plot
with \dQuote{algrebraic} coordinates,
if \code{FALSE} or \code{"none"} don't annotate,
if \code{"cartesian"} annotate the plot with \dQuote{cartesian} coordinates.}

\item{.f}{Low level graphics function to use e.g. \code{\link[=grid.piece]{grid.piece()}}, \code{\link[=piece3d]{piece3d()}}, \code{\link[=piece]{piece()}}, or \code{\link[=piece_mesh]{piece_mesh()}}.}

\item{cfg}{A piecepackr configuration list}

\item{envir}{Environment (or named list) of piecepackr configuration lists}

\item{n_transitions}{Integer, if over zero (the default)
how many transition frames to add between moves.}

\item{n_pauses}{Integer, how many paused frames per completed move.}

\item{fps}{Double, frames per second.}

\item{width}{Width of animation (in inches).  Inferred by default.}

\item{height}{Height of animation (in inches).  Inferred by default.}

\item{ppi}{Resolution of animation in pixels per inch.
By default set so image max 600 pixels wide or tall.}

\item{new_device}{If \code{file} is \code{NULL} should we open up a new graphics device?}

\item{annotation_scale}{Multiplicative factor that scales (stretches) any annotation coordinates.
By default uses \code{attr(df, "scale_factor") \%||\% 1}.}
}
\value{
Nothing, as a side effect creates an animation.
}
\description{
\code{animate_piece()} animates board game pieces.
}
\examples{
  # Basic tic-tac-toe animation
  dfs <- list()
  d.frame <- function(piece_side = "bit_back", ..., rank = 1L) {
                 data.frame(piece_side = piece_side, ..., rank = rank,
                            cfg = "checkers1", stringsAsFactors = FALSE)
  }
  df <- d.frame("board_back", suit = 2L, rank = 3L, x = 2, y = 2, id = "1")
  dfs[[1L]] <- df
  df <- rbind(df, d.frame(suit = 1L, x = 2, y = 2, id = "2"))
  dfs[[2L]] <- df
  df <- rbind(df, d.frame(suit = 2L, x = 1, y = 2, id = "3"))
  dfs[[3L]] <- df
  df <- rbind(df, d.frame(suit = 1L, x = 3, y = 1, id = "4"))
  dfs[[4L]] <- df
  df <- rbind(df, d.frame(suit = 2L, x = 1, y = 3, id = "5"))
  dfs[[5L]] <- df
  df <- rbind(df, d.frame(suit = 1L, x = 1, y = 1, id = "6"))
  dfs[[6L]] <- df
  df <- rbind(df, d.frame(suit = 2L, x = 3, y = 3, id = "7"))
  dfs[[7L]] <- df
  df <- rbind(df, d.frame(suit = 1L, x = 2, y = 1, id = "8"))
  dfs[[8L]] <- df

  ## Press enter to walk through moves in a "game" in new graphics device
  if (interactive()) {
      animate_piece(dfs, file = NULL)
  }

  ## Save GIF of game with animation transitions
  \dontrun{# May take more than 5 seconds on CRAN servers
  if ((requireNamespace("animation", quietly = TRUE) ||
       requireNamespace("gifski", quietly = TRUE)) &&
      requireNamespace("tweenr", quietly = TRUE)) {
      file <- tempfile("tic-tac-toe", fileext = ".gif")
      animate_piece(dfs, file = file,
                    n_transitions = 5L, n_pauses = 2L, fps = 9)
  }
  }

}
