% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.aggregate_piar_index.R
\name{vcov.aggregate_piar_index}
\alias{vcov.aggregate_piar_index}
\title{Bootstrap variance for a price index with replicate weights}
\source{
The \code{vcov()} method was influenced by a SAS routine by Justin
Francis that was first ported to R by Ambuj Dewan, and subsequently
rewritten by Steve Martin.
}
\usage{
\method{vcov}{aggregate_piar_index}(object, repweights, ..., mse = TRUE, sparse = FALSE)
}
\arguments{
\item{object}{An aggregate price index, as made by
\code{\link[=aggregate.piar_index]{aggregate()}}.}

\item{repweights}{A matrix, or something that can be coerced into one, of
bootstrap replicate weights with a row for each elemental aggregate and a
column for each replicate.}

\item{...}{Not currently used.}

\item{mse}{Should variance be centered off the value of the index in
\code{object} (the default), or the mean of the replicates?}

\item{sparse}{Use sparse matrices from \pkg{Matrix} when aggregating the
index. Faster for indexes with large aggregation structures. The default
uses regular dense matrices.}
}
\value{
A matrix of variances with a row for each upper-level index and a
column for each time period.
}
\description{
Estimate the sampling variance for an aggregate price index when using a
sample of elemental aggregates.
}
\details{
This function is a simple wrapper that reaggregates the elemental indexes in
\code{object} using the bootstrap replicate weights in \code{repweights} to
get a collection of aggregate indexes from which the variance is calculated.

This approach is usually applicable when elemental aggregates are sampled
with a stratified design that follows the aggregation structure, so that
there is no correlation between the index values for different levels of the
index. It ignores any variation from the elemental indexes (which often use
judgmental sampling), and ultimately depends on the method of generating
replicate weights. (Chapters 3 and 4 of Selvanathan and Rao (1994),
especially section 4.7, provide analytic variance estimators for some common
price indexes that are applicable with simple random sampling.)

Note that any missing elemental indexes need to be explicitly imputed prior
to using this method, otherwise they will propagate throughout the variance
calculation.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

# A two-level aggregation structure

pias <- aggregation_structure(
  list(c("top", "top", "top"), c("a", "b", "c")), 1:3
)

repweights <- matrix(c(0, 2, 3, 1, 2, 4, 2, 3, 3), 3)

# Calculate Jevons elemental indexes

elemental <- with(prices, elemental_index(rel, period, ea))

# Aggregate

index <- aggregate(elemental, pias, na.rm = TRUE)

# Calculate variance

vcov(index, repweights)

}
\references{
Selvanathan, E. A., and Rao, D. S. P. (1994).
\emph{Index Numbers: A Stochastic Approach}. MacMillan.
}
\seealso{
The \code{sps_repweights()} function in the \pkg{sps} package to
generate replicates weights when elemental aggregates are sampled using
sequential Poisson sampling.

Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()}
}
\concept{index methods}
