% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-special.R
\name{plot_phylota_pa}
\alias{plot_phylota_pa}
\title{Plot presence/absence matrix}
\usage{
plot_phylota_pa(phylota, cids, txids, cnms = cids, txnms = txids)
}
\arguments{
\item{phylota}{Phylota object}

\item{cids}{Vector of cluster IDs}

\item{txids}{Vector of taxonomic IDs}

\item{cnms}{Cluster names}

\item{txnms}{Taxonomic names}
}
\value{
geom_object
}
\description{
Plot presence/absence of taxa by each
cluster in phylota object.
}
\details{
Cluster names and taxonomic names can be given to the function, by
default IDs are used.
}
\examples{
library(phylotaR)
data(cycads)
# drop all but first ten
cycads <- drop_clstrs(cycads, cycads@cids[1:10])
# plot all
p <- plot_phylota_pa(phylota = cycads, cids = cycads@cids, txids = cycads@txids)
print(p)  # lots of information, difficult to interpret
# get genus-level taxonomic names
genus_txids <- get_txids(cycads, txids = cycads@txids, rnk = 'genus')
genus_txids <- unique(genus_txids)
# dropping missing
genus_txids <- genus_txids[genus_txids !=  '']
genus_nms <- get_tx_slot(cycads, genus_txids, slt_nm = 'scnm')
# make alphabetical for plotting
genus_nms <- sort(genus_nms, decreasing = TRUE)
# generate geom_object
p <- plot_phylota_pa(phylota = cycads, cids = cycads@cids, txids = genus_txids,
                     txnms = genus_nms)
# plot
print(p)  # easier to interpret
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_sq_slot}},
  \code{\link{get_stage_times}}, \code{\link{get_tx_slot}},
  \code{\link{get_txids}}, \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
