% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fishnet.R
\name{fishnet}
\alias{fishnet}
\title{Create a fishnet of regular grids}
\usage{
fishnet(mask, res = 0.5)
}
\arguments{
\item{mask}{a polygon shapefile covering the boundary of the survey region.}

\item{res}{the grain size of the grid cells in decimal degrees (default).}
}
\value{
A spatial polygon object of equal area grid cells covering the
defined area.
}
\description{
The \code{fishnet} function creates a regular grid of locations covering
the study area at various grain sizes.
}
\examples{
file <- system.file("nigeria/nigeria.rds", package="phyloregion")
d <- readRDS(file)
d1 <- fishnet(d, res = 0.75)
}
\references{
Phillips, S.J., Anderson, R.P. & Schapire, R.E. (2006) Maximum entropy
modeling of species geographic distributions. \emph{Ecological Modelling}
\strong{190}: 231-259.
}
\keyword{bioregion}
