% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin-phybreak.R
\name{thin_phybreak}
\alias{thin_phybreak}
\title{Remove posterior samples from a phybreak-object.}
\usage{
thin_phybreak(x, thin = 1, nkeep = Inf)
}
\arguments{
\item{x}{An object of class \code{phybreak}.}

\item{thin}{The thinning interval to use.}

\item{nkeep}{the number of most recent samples to keep. If \code{nkeep = Inf} (default), the whole chain is
thinned and returned. Otherwise, samples from the tail are kept.}
}
\value{
The \code{phybreak}-object provided as input, but with fewer posterior samples.
}
\description{
The function removes (all or some) posterior samples by thinning and/or removing the first part of the chain, 
  but keeps the state of variables and parameters intact.
}
\examples{
#First create a phybreak-object
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

MCMCstate <- thin_phybreak(MCMCstate, thin = 2)
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
