% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_aq_response.R
\name{fit_aq_response2}
\alias{fit_aq_response2}
\title{Fit photosynthetic light-response curves}
\usage{
fit_aq_response2(
  .data,
  .model = "default",
  .method = "ls",
  usealpha_Q = FALSE,
  alpha_Q = 0.84,
  quiet = FALSE,
  brm_options = NULL
)
}
\arguments{
\item{.data}{A data frame containing plant ecophysiological data. See \code{\link[=required_variables]{required_variables()}} for the variables required for each model.}

\item{.model}{A character string of model name to use. See \code{\link[=get_all_models]{get_all_models()}}.}

\item{.method}{A character string of the statistical method to use: 'ls' for least-squares and 'brms' for Bayesian model using \code{\link[brms:brm]{brms::brm()}}. Default is 'ls'.}

\item{usealpha_Q}{Flag. Should light intensity be multiplied by \code{alpha_Q} before fitting? Default is FALSE (i.e. assume that '.Q' is absorbed light).}

\item{alpha_Q}{Number. Absorbance of incident light. Default value is 0.84. Ignored if \code{usealpha_Q = FALSE}.}

\item{quiet}{Flag. Should messages be suppressed? Default is FALSE.}

\item{brm_options}{A list of options passed to \code{\link[brms:brm]{brms::brm()}} if \code{.method = "brms"}. Default is NULL.}
}
\value{
\itemize{
\item If \code{.method = 'ls'}: an \code{\link[stats:nls]{stats::nls()}} object.
\item If \code{.method = 'brms'}: a \code{\link[brms:brmsfit-class]{brms::brmsfit()}} object.
}
}
\description{
We recommend using \code{\link[=fit_photosynthesis]{fit_photosynthesis()}} with argument \code{.photo_fun = "aq_response"} rather than calling this function directly.
}
\note{
Rd fitted in this way is essentially the same as the Kok (1956) method, and
represents a respiration value in the light that may not be accurate.
Rd output should thus be interpreted more as a residual parameter to ensure
an accurate fit of the light response parameters. Model originally from
Marshall & Biscoe (1980).
}
\examples{
\donttest{

library(broom)
library(dplyr)
library(photosynthesis)

# Read in your data
dat = system.file("extdata", "A_Ci_Q_data_1.csv", package = "photosynthesis") |>
  read.csv() |>
  # Set grouping variable
  mutate(group = round(CO2_s, digits = 0)) |>
  # For this example, round sequentially due to CO2_s set points
  mutate(group = as.factor(round(group, digits = -1)))

# Fit one light-response curve
fit = fit_photosynthesis(
  .data = filter(dat, group == 600),
  .photo_fun = "aq_response",
  .vars = list(.A = A, .Q = Qabs),
)

# The 'fit' object inherits class 'nls' and many methods can be used

## Model summary:
summary(fit)

## Estimated parameters:
coef(fit)

## 95\% confidence intervals:
confint(fit)

## Tidy summary table using 'broom::tidy()'
tidy(fit, conf.int = TRUE, conf.level = 0.95)

# Fit multiple curves with **photosynthesis** and **purrr**

library(purrr)

fits = dat |>
  split(~ group) |>
  map(fit_photosynthesis, .photo_fun = "aq_response", .vars = list(.A = A, .Q = Qabs))

}

}
\references{
Marshall B, Biscoe P. 1980. A model for C3 leaves describing the
dependence of net photosynthesis on irradiance. J Ex Bot 31:29-39
}
