% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metaphone}
\alias{metaphone}
\title{Metaphone}
\usage{
metaphone(word, maxCodeLen = 10L)
}
\arguments{
\item{word}{character vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
metaphone encoded character vector
}
\description{
The Metaphone phonentic algorithm
}
\details{
The function \code{metaphone} phonentically encodes the
given string using the metaphone algorithm.  There is some discrepency
with respect to how the metaphone algorithm actually works.  For
instance, there is a version in the Java Apache Commons library.
There is a version provided within PHP.  These do not provide the same
results.  On the questionable theory that the implementation in PHP
is probably more well known, this code should match it in output.

This implementation is based on a Javascript implementation which is
itself based on the PHP internal implementation.

The variable \code{maxCodeLen} is the limit on how long the returned
metaphone should be.
}
\examples{
metaphone("wheel")
metaphone(c("school", "benji"))

}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{lein}}, \code{\link{nysiis}},
  \code{\link{soundex}}, \code{\link{statcan}}
}

