% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_additive_error_model}
\alias{set_additive_error_model}
\title{set_additive_error_model}
\usage{
set_additive_error_model(model, data_trans = NULL, series_terms = 2)
}
\arguments{
\item{model}{(Model) Set error model for this model}

\item{data_trans}{(str or expression) A data transformation expression or NULL (default) to use the transformation
specified by the model. Series expansion will be used for approximation.}

\item{series_terms}{(integer) Number of terms to use for the series expansion approximation for data
transformation.}
}
\value{
(Model) Reference to the same model object
}
\description{
Set an additive error model. Initial estimate for new sigma is :math:\verb{(min(DV)/2)²}.

The error function being applied depends on the data transformation. The table displays
some examples.

+------------------------+----------------------------------------+
| Data transformation    | Additive error                         |
+========================+========================================+
| :math:\code{y}              | :math:\code{f + epsilon_1}                 |
+------------------------+----------------------------------------+
| :math:\code{log(y)}         | :math:\verb{log(f) + frac\{epsilon_1\}\{f\}} |
+------------------------+----------------------------------------+
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model$statements$find_assignment("Y")
set_additive_error_model(model)
model$statements$find_assignment("Y")
model <- load_example_model("pheno")
model$statements$find_assignment("Y")
set_additive_error_model(model, data_trans="log(Y)")
model$statements$find_assignment("Y")
}
}
\seealso{
set_proportional_error_model : Proportional error model

set_combined_error_model : Combined error model
}
