% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationMatrix.R
\name{cor.table}
\alias{cor.table}
\title{Correlation Matrix.}
\usage{
cor.table(x, y, type = "none", dig = 2, correlation = "pearson")
}
\arguments{
\item{x}{Variable or set of variables in the form of a vector or dataframe
to correlate with \code{y} (if \code{y} is specified) in an any asymmetric
correlation matrix or with itself in a symmetric correlation matrix (if
\code{y} is not specified).}

\item{y}{(optional) Variable or set of variables in the form of a vector or
dataframe to correlate with \code{x}.}

\item{type}{Type of correlation matrix to print. One of:
\itemize{
  \item \code{"none"} = correlation matrix with \emph{r}, \emph{n},
  \emph{p}-values
  \item \code{"latex"} = generates latex code for correlation matrix with only
  \emph{r}-values
  \item \code{"latexSPSS"} = generates latex code for full SPSS-style
  correlation matrix
  \item \code{"manuscript"} = only \emph{r}-values, 2 digits; works with
  \code{x} only (cannot enter variables for \code{y})
  \item \code{"manuscriptBig"} = only \emph{r}-values, 2 digits, no asterisks;
  works with \code{x} only (cannot enter variables for \code{y})
  \item \code{"manuscriptLatex"} = generates latex code for: only
  \emph{r}-values, 2 digits; works with \code{x} only (cannot enter variables
  for \code{y})
  \item \code{"manuscriptBigLatex"} = generates latex code for: only
  \emph{r}-values, 2 digits, no asterisks; works with \code{x} only (cannot
  enter variables for \code{x})
}}

\item{dig}{Number of decimals to print.}

\item{correlation}{Method for calculating the association. One of:
\itemize{
  \item \code{"pearson"} = Pearson product moment correlation coefficient
  \item \code{"spearman"} = Spearman's rho
  \item \code{"kendall"} = Kendall's tau
}}
}
\value{
A correlation matrix.
}
\description{
Function that creates a correlation matrix similar to SPSS output.
}
\details{
Co-created by Angela Staples (astaples@emich.edu) and Isaac Petersen
(isaac-t-petersen@uiowa.edu). For a partial correlation matrix, see
\link{partialcor.table}.
}
\examples{
# Prepare Data
data("mtcars")

# Correlation Matrix
cor.table(mtcars[,c("mpg","cyl","disp")])
cor.table(mtcars[,c("mpg","cyl","disp")])
cor.table(mtcars[,c("mpg","cyl","disp")], dig = 3)
cor.table(mtcars[,c("mpg","cyl","disp")], dig = 3, correlation = "spearman")

cor.table(mtcars[,c("mpg","cyl","disp")], type = "manuscript", dig = 3)
cor.table(mtcars[,c("mpg","cyl","disp")], type = "manuscriptBig")

table1 <- cor.table(mtcars[,c("mpg","cyl","disp")], type = "latex")
table2 <- cor.table(mtcars[,c("mpg","cyl","disp")], type = "latexSPSS")
table3 <- cor.table(mtcars[,c("mpg","cyl","disp")], type = "manuscriptLatex")
table4 <- cor.table(mtcars[,c("mpg","cyl","disp")], type = "manuscriptBigLatex")

cor.table(mtcars[,c("mpg","cyl","disp")], mtcars[,c("drat","qsec")])
cor.table(mtcars[,c("mpg","cyl","disp")], mtcars[,c("drat","qsec")], type = "manuscript", dig = 3)
}
\seealso{
Other correlations: 
\code{\link{addText}()},
\code{\link{crossTimeCorrelation}()},
\code{\link{crossTimeCorrelationDF}()},
\code{\link{partialcor.table}()},
\code{\link{vwReg}()}
}
\concept{correlations}
