% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_df.R
\name{hash_df}
\alias{hash_df}
\title{Data with hash table internals}
\value{
A \code{hash_df} object, built on \code{R6} and \code{env} \code{S3} classes
}
\description{
Create a \code{data.frame} built on the \code{environment}
\code{S3} class and embedded in an \code{R6} object. The primary advantage
of this structure is the reference semantics, which means that
elements (in this case \code{data.frame} columns) are not copied upon
modification. Although modern R avoids making deep copies of
\code{data.frame}s when they are modified, the copy on modify semantics
applied to the container (the list of pointers to the columns of the \code{data.frame}),
can still significantly slow down loops that modify large numbers of columns
on wide \code{data.frame}s.

\code{hash_df}s also offer access to their columns in amortized constant
time (\code{O(1)}) due to their internal structure as a hash table.

\code{hash_df}s are bare-bones, with methods for adding (\code{bind}ing)
and deleting (\code{unbind}ing) variables as well as printing a
preview of the data. In addition, {dplyr} functions \code{select}
and \code{mutate} (as well as its scoped versions) have implementations for
\code{hash_df}'s (that do not depend on \code{{dplyr}}). Note that in \code{{dplyr}},
\code{across()} and \code{tidyselect()} have superseded scoped verbs. However,
\code{hash_df}s do not understand \code{tidyselect}, so we must rely on the
scoped versions (\verb{mutate_*}) when wrangling these objects.
Data wrangling and analysis functions not implemented in \code{hash_df}
should be done after converting back to a \code{data.frame}
object with \code{hash_df$return_df()}.
}
\examples{
df <- hash_df$new(iris)
for (name in df$vars) {
 if (is.numeric(df$data[[name]])) df$data[[name]] <- 2 * df$data[[name]]
}

hash_mtcars <- hash_df$new(mtcars)
hash_mtcars$data <- lapply(hash_mtcars$data, function(x) log(x + 1))
hash_mtcars$print()

wide_df <- as.data.frame(matrix(1:5000, nrow = 2))
hash_wide_df <- hash_df$new(wide_df)

# using a `for` loop:
for (name in hash_wide_df$vars) {
  hash_wide_df$data[[name]] <- -1 *  hash_wide_df$data[[name]]
}

# using `lapply`:
hash_wide_df$data <- lapply(hash_wide_df$data, function(x) x * -1)

# using `mutate`:
hash_wide_df$mutate(~.x * -1)

\dontrun{
timer <- bench::mark(
 check = F,
 for(name in names(wide_df)) wide_df[[name]] <- -1 * wide_df[[name]],
 for (name in hash_wide_df$vars) hash_wide_df$data[[name]] <- -1 *  hash_wide_df$data[[name]]
)}

#> hash_df: Median = 22.2.3ms
#> data.frame: Median = 615.3ms


## ------------------------------------------------
## Method `hash_df$bind`
## ------------------------------------------------

df <- hash_df$new(iris)
df$bind(col_ones = 1, col_his = "hi")
df$print()

## ------------------------------------------------
## Method `hash_df$unbind`
## ------------------------------------------------

df <- hash_df$new(iris)
df$unbind(Petal.Length)
df$print()

## ------------------------------------------------
## Method `hash_df$mutate`
## ------------------------------------------------

df <- hash_df$new(iris)
df$mutate(Sepal.Size = Sepal.Length * Sepal.Width)
df$print()

## ------------------------------------------------
## Method `hash_df$mutate_if`
## ------------------------------------------------

df <- hash_df$new(iris)
df$mutate_if(is.numeric, log)
df$print()

## ------------------------------------------------
## Method `hash_df$mutate_all`
## ------------------------------------------------

df <- hash_df$new(mtcars)
df$mutate_all(~.x - mean(.x))
df$print()

## ------------------------------------------------
## Method `hash_df$mutate_at`
## ------------------------------------------------

df <- hash_df$new(iris)
df$mutate_at("Sepal*", ~.x / 100)
df$print()

## ------------------------------------------------
## Method `hash_df$select`
## ------------------------------------------------

df <- hash_df$new(iris)
df$select(Sepal.Length, Species)
df$print()

## ------------------------------------------------
## Method `hash_df$select_if`
## ------------------------------------------------

df <- hash_df$new(iris)
df$select_if(is.numeric)
df$print()

## ------------------------------------------------
## Method `hash_df$select_at`
## ------------------------------------------------

df <- hash_df$new(iris)
df$select_at("Sepal*")
df$print()
}
\seealso{
\code{\link[dplyr:mutate]{dplyr::mutate()}}

\code{\link[dplyr:mutate_all]{dplyr::mutate_if()}}, \code{\link[purrr:as_mapper]{purrr::as_mapper()}}

\code{\link[base:grep]{base::grepl()}}

\code{\link[dplyr:select]{dplyr::select()}}

\code{\link[dplyr:select_all]{dplyr::select_if()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{an \code{environment} containing the the data from a \code{data.frame}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nrow}}{the number of rows of the \code{data.frame}}

\item{\code{ncol}}{the number of columns of the \code{data.frame}}

\item{\code{vars}}{the variables (column names) of the \code{data.frame}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-bind}{\code{hash_df$bind()}}
\item \href{#method-unbind}{\code{hash_df$unbind()}}
\item \href{#method-return_df}{\code{hash_df$return_df()}}
\item \href{#method-print}{\code{hash_df$print()}}
\item \href{#method-new}{\code{hash_df$new()}}
\item \href{#method-View}{\code{hash_df$View()}}
\item \href{#method-mutate}{\code{hash_df$mutate()}}
\item \href{#method-mutate_if}{\code{hash_df$mutate_if()}}
\item \href{#method-mutate_all}{\code{hash_df$mutate_all()}}
\item \href{#method-mutate_at}{\code{hash_df$mutate_at()}}
\item \href{#method-select}{\code{hash_df$select()}}
\item \href{#method-select_if}{\code{hash_df$select_if()}}
\item \href{#method-select_at}{\code{hash_df$select_at()}}
\item \href{#method-clone}{\code{hash_df$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bind"></a>}}
\if{latex}{\out{\hypertarget{method-bind}{}}}
\subsection{Method \code{bind()}}{
add \code{data.frame} columns
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$bind(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{named columns to add}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$bind(col_ones = 1, col_his = "hi")
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unbind"></a>}}
\if{latex}{\out{\hypertarget{method-unbind}{}}}
\subsection{Method \code{unbind()}}{
remove \code{data.frame} columns
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$unbind(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{names of the columns to remove}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$unbind(Petal.Length)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-return_df"></a>}}
\if{latex}{\out{\hypertarget{method-return_df}{}}}
\subsection{Method \code{return_df()}}{
return the \code{data.frame} from a \code{hash_df}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$return_df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print a preview of the \code{data.frame}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
create a new \code{hash_df} from a \code{data.frame}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$new(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{a \code{data.frame}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-View"></a>}}
\if{latex}{\out{\hypertarget{method-View}{}}}
\subsection{Method \code{View()}}{
open the data in the \code{View} pane
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$View()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mutate"></a>}}
\if{latex}{\out{\hypertarget{method-mutate}{}}}
\subsection{Method \code{mutate()}}{
a bare-bones \code{dplyr::mutate} that takes advantage of the hashed data structure
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$mutate(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{named R expressions to mutate the columns by}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$mutate(Sepal.Size = Sepal.Length * Sepal.Width)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mutate_if"></a>}}
\if{latex}{\out{\hypertarget{method-mutate_if}{}}}
\subsection{Method \code{mutate_if()}}{
Think \code{dplyr::mutate_if} or \code{mutate(across(where(...)))},
but only taking one function, not a list.
For all the scoped mutates in \code{{dplyr}}, functions can be functions/lambdas, formulas, or
certain syntactic sugar expressions like \code{mean} --> \code{~mean(.x)}.
See \code{purrr::as_mapper} for more information about function conversions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$mutate_if(test, fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{test}}{a predicate function}

\item{\code{fun}}{a function to apply when \code{test} is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$mutate_if(is.numeric, log)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mutate_all"></a>}}
\if{latex}{\out{\hypertarget{method-mutate_all}{}}}
\subsection{Method \code{mutate_all()}}{
Think \code{dplyr::mutate_all} or \code{mutate(across(everything, ...))},
but again only taking one function, not a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$mutate_all(fun)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{a function to apply to every variable}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(mtcars)
df$mutate_all(~.x - mean(.x))
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mutate_at"></a>}}
\if{latex}{\out{\hypertarget{method-mutate_at}{}}}
\subsection{Method \code{mutate_at()}}{
Think \code{dplyr::mutate_at}, but again only taking one function, not a list.
Also does not understand \code{tidyselect} syntax, so \code{regex} must be a regular expression
that is understood by \code{base::grepl}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$mutate_at(regex, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{regex}}{a regular expression}

\item{\code{fun}}{a function to apply to variables whose names match \code{regex}}

\item{\code{...}}{additional arguments passed to \code{regex}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$mutate_at("Sepal*", ~.x / 100)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-select"></a>}}
\if{latex}{\out{\hypertarget{method-select}{}}}
\subsection{Method \code{select()}}{
A bare-bones \code{dplyr::select} that takes advantage of the hashed data structure
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$select(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{variables to select, separated by a comma}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$select(Sepal.Length, Species)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-select_if"></a>}}
\if{latex}{\out{\hypertarget{method-select_if}{}}}
\subsection{Method \code{select_if()}}{
Think \code{dplyr::select_if}. Note that \code{peruse::hash_df$select_if()}
does not take advantage of the particular hashed data type and is only included for completeness.
There is no reason to think that this will be more efficient than \code{dplyr::select_if},
and it may be less efficient.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$select_if(test)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{test}}{a predicate function to subset data}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$select_if(is.numeric)
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-select_at"></a>}}
\if{latex}{\out{\hypertarget{method-select_at}{}}}
\subsection{Method \code{select_at()}}{
Think \code{dplyr::select_at}, but again without \code{tidyselect}
specification, so \code{regex} must be understood by \code{grepl}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$select_at(regex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{regex}}{a regular expression to subset the data}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- hash_df$new(iris)
df$select_at("Sepal*")
df$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{hash_df$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
