% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_direct_match.R
\name{genus_match}
\alias{genus_match}
\title{Match Genus Names Against Peru Mammals Database}
\usage{
genus_match(df, target_df = NULL)
}
\arguments{
\item{df}{A data frame or tibble containing the genus names to be matched.
Must include column: Orig.Genus}

\item{target_df}{A data frame representing the peru_mammals database.
Must include column: genus}
}
\value{
A tibble with an additional logical column \code{genus_match} indicating whether
the genus was successfully matched (\code{TRUE}) or not (\code{FALSE}), plus column
\code{Matched.Genus} for matched records.
}
\description{
Performs direct matching of genus names against the unique genera listed
in the peru_mammals database. Useful for Rank 1 (genus-only) names.
}
\details{
This function is typically used for names submitted at the genus level
(Rank 1). When a genus is matched, all species of that genus in peru_mammals
can be retrieved for further processing (e.g., suggesting possible species
to the user).
}
\keyword{internal}
