% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{splitChr}
\alias{splitChr}
\title{Split markers into chromosomes}
\usage{
splitChr(rf, height = 0.4, nchr = NULL, method = "single",
  filter = FALSE, thresh = 0.05, rm.dup = TRUE)
}
\arguments{
\item{rf}{Matrix of pairwise recombination frequencies.}

\item{height}{Threshold value for grouping the markers.}

\item{nchr}{Expected number of chromosomes.}

\item{method}{Default is "single", which is used for the hierarchical clustering.}

\item{filter}{Logical, if the result should be filtered or not. Default is FALSE. Creates zeros for the markers below the threshold.}

\item{thresh}{Threshold for filtering. Default is 0.05, i.e. linkage groups with less than 5\% of markers, are filtered out.}

\item{rm.dup}{Logical, if the duplicated markers should be filtered out.
TRUE is highly recommended because the markers have no added value for the linkage map.}
}
\value{
Vector of cluster relationship. Same length and order as the matrix of recombination frequencies.
}
\description{
This function splits markers into linkage groups (LG), which ideally represent chromosomes.
The split is based on hierarchical clustering with a single linkage distance.
}
\examples{
data(simTetra)
simTetrageno<-bases2genotypes(simTetra, 4)
rfMat<-calcRec(simTetrageno, 4)
splitChr(rfMat, nchr = 7)
}

