% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{getASubset}
\alias{getASubset}
\title{Subset of additive relationship matrix}
\usage{
getASubset(ped, labs)
}
\arguments{
\item{ped}{\code{\link{pedigree}}}

\item{labs}{a character vector or a factor giving individual labels to
which to restrict the relationship matrix and corresponding factor using
Colleau et al. (2002) algorithm. If \code{labs} is a factor then the levels
of the factor are used as the labels. Default is the complete set of
individuals in the pedigree.}
}
\value{
matrix (\linkS4class{dsCMatrix} - symmetric sparse)
}
\description{
Returns subset of the additive relationship matrix for the pedigree.
}
\examples{
ped <- pedigree(sire = c(NA, NA, 1,  1, 4, 5),
                dam =  c(NA, NA, 2, NA, 3, 2),
                label = 1:6)
(A <- getA(ped))
(ASubset  <- A[4:6, 4:6])
(ASubset2 <- getASubset(ped, labs = 4:6))

(ASubset3  <- A[6:4, 6:4])
(ASubset4 <- getASubset(ped, labs = 6:4))

# Test for correctness
stopifnot(!any(abs(ASubset - ASubset2) > .Machine$double.eps))
stopifnot(!any(abs(ASubset3 - ASubset4) > .Machine$double.eps))
stopifnot(Matrix::isSymmetric(ASubset2))
stopifnot(Matrix::isSymmetric(ASubset4))
}
\references{
Colleau, J.-J. An indirect approach to the extensive calculation of
  relationship coefficients. Genet Sel Evol 34, 409 (2002).
  https://doi.org/10.1186/1297-9686-34-4-409
}
