% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPeds.R
\name{buildPeds}
\alias{buildPeds}
\title{Build a list of pedigrees}
\usage{
buildPeds(
  labs,
  sex,
  extra = "parents",
  age = NULL,
  knownPO = NULL,
  allKnown = FALSE,
  notPO = NULL,
  noChildren = NULL,
  connected = TRUE,
  linearInb = TRUE,
  maxLinearInb = NULL,
  sexSymmetry = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{labs}{A character vector of ID labels.}

\item{sex}{A vector of the same length as \code{labs}, with entries 1 (male) or 2
(female).}

\item{extra}{Either the word "parents", or a nonnegative integer. See
details.}

\item{age}{A numeric or character vector. If numeric, and \code{age[i] < age[j]},
then individual \code{i} will not be an ancestor of individual \code{j}. The numbers
themselves are irrelevant, only the partial ordering. Note that no
interpretation is made about individuals of equal age.

Alternatively \code{age} may be a character vector of inequalities, e.g., \code{age = c("1>2", "1>3")}. This syntax allows finer control than the numeric
version.}

\item{knownPO}{A list of vectors of length 2, containing the ID labels of
pairs known to be parent-offspring. By default, both directions are
considered; use \code{age} to force a specific direction.}

\item{allKnown}{A logical. If TRUE, no other pairs than \code{knownPO} will be
assigned as parent-offspring. If FALSE (default), all pairs except those in
\code{notPO} are treated as potential parent-offspring.}

\item{notPO}{A list of vectors of length 2, containing the ID labels of pairs
known \emph{not} to be parent-offspring.}

\item{noChildren}{A vector of ID labels, indicating individuals without
children of their own.}

\item{connected}{A logical. If TRUE (default), only connected pedigrees are
returned.}

\item{linearInb}{Either TRUE (allow any linear inbreeding), FALSE (disallow
linear inbreeding) or a nonnegative integer indicating the maximum
separation linearly related spouses. For example, \code{linearInb = 1} allows
mating between parent and child, but not between grandparent and grandchild
(or more distant).}

\item{maxLinearInb}{Deprecated; replaced by \code{linearInb}.}

\item{sexSymmetry}{A logical. If TRUE (default), pedigrees which are equal
except for the gender distribution of the \emph{added} parents, are regarded as
equivalent, and only one of each equivalence class is returned. Example:
paternal vs. maternal half sibs.}

\item{verbose}{A logical.}
}
\value{
A list of pedigrees. Each element is a \code{ped} object or a list of
such.
}
\description{
Build all pedigrees between a set of individuals, subject to given
restrictions.
}
\details{
The parameter \code{extra} controls which of two algorithms are used to create the
pedigree list.

If \code{extra} is a nonnegative integer, it determines the number of extra
individuals allowed in the iterative pedigree construction. These extras
start off with undetermined sex, meaning that both males and females are
used. It should be noted that the final pedigrees may contain additional
extras, since missing parents are added at the end.

If \code{extra} is the word "parents", the algorithm is not iterative. It first
generates all directed acyclic graphs between the original individuals. Then
their parents are added and merged in all possible ways. This option has the
advantage of not requiring an explicit/ad hoc number of "extras", but works
best in smaller cases.
}
\examples{

# Showing off a few of the options
plist = buildPeds(1:3, sex = c(1,2,1), extra = 1, knownPO = list(1:2),
                  age = "1 > 2", linearInb = FALSE)
stopifnot(length(plist) == 12)


# Slightly different output with `extra = "parents"`
plist2 = buildPeds(1:3, sex = c(1,2,1), extra = "parents", knownPO = list(1:2),
                   age = "1 > 2", linearInb = FALSE)
stopifnot(length(plist2) == 8)


}
