% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whittle_conflicts_startmonth.R
\name{whittle_conflicts_startmonth}
\alias{whittle_conflicts_startmonth}
\alias{wc_stmon}
\title{Whittle Duplicate Conflict-Years by Lowest Start Month}
\usage{
whittle_conflicts_startmonth(data)

wc_stmon(...)
}
\arguments{
\item{data}{a data frame with a declared conflict attribute type.}

\item{...}{optional, only to make the shortcut work}
}
\value{
\code{whittle_conflicts_startmonth()} takes a dyad-year data frame with a declared conflict attribute type and, grouping by the
dyad and year, returns just those observations that have the lowest start month.
}
\description{
\code{whittle_conflicts_startmonth()} is in a class of do-it-yourself functions for coercing (i.e. "whittling") conflict-year
data with cross-sectional units to unique conflict-year data by cross-sectional unit. The inspiration here is clearly the problem
of whittling dyadic dispute-year data into true dyad-year data (like in the Gibler-Miller-Little conflict data). This particular
function will keep the observations that have the lowest start month.
}
\details{
Dyads are capable of having multiple disputes in a given year, which can create a problem
for merging into a complete dyad-year data frame. Consider the case of France and Italy in 1860, which
had three separate dispute onsets that year (MID#0112, MID#0113, MID#0306), as illustrative of the problem.
The default process in \pkg{peacesciencer} employs several rules to whittle down these duplicate dyad-years for
merging into a dyad-year data frame. These are available in \code{add_cow_mids()} and \code{add_gml_mids()}.

This really should be one of the last exclusion rules a researcher uses. There is no substantive reason to
assume the lower start month matters for the cause of isolating "serious" or "severe" disputes in the presence
of duplicates. It's really just a way of isolating which duplicated observation happened first where remaining duplicates are
otherwise very similar to each other.

\code{wc_stmon()} is a simple, less wordy, shortcut for the same function.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
gml_dirdisp \%>\% whittle_conflicts_onsets() \%>\% whittle_conflicts_startmonth()

cow_mid_dirdisps \%>\% whittle_conflicts_onsets() \%>\% whittle_conflicts_startmonth()


}

}
\references{
Miller, Steven V. 2021. "How {peacesciencer} Coerces Dispute-Year Data into Dyad-Year Data".
URL: \url{http://svmiller.com/peacesciencer/articles/coerce-dispute-year-dyad-year.html}
}
\author{
Steven V. Miller
}
