% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_sdp_gdp.R
\name{add_sdp_gdp}
\alias{add_sdp_gdp}
\title{Add (Surplus and Gross) Domestic Product Data}
\usage{
add_sdp_gdp(data, system)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed") or a state-year data frame.}

\item{system}{a character specifying whether the user wants Correlates of War
state-years ("cow") or Gleditsch-Ward ("gw") state-years.}
}
\value{
\code{add_sdp_gdp()} takes a dyad-year data frame or state-year data frame and adds information
about the estimated gross domestic product (in 2011 USD) for that year, the estimated population in that year,
and what Anders, Fariss and Markowitz term the "surplus domestic product" in that year. If the data are dyad-year, the function
adds 6 total columns for the first state (i.e. \code{ccode1}) and the second state (i.e. \code{ccode2}) for all these estimates.
If the data are state-year, the function returns three additional columns to the original data that contain that same information
for a given state in a given year.
}
\description{
\code{add_sdp_gdp()} allows you to add estimated GDP and "surplus" domestic product data from a 2020 analysis published in
\emph{International Studies Quarterly} by Anders, Fariss, and Markowitz.
}
\details{
The function leans on attributes of the data that are provided by the \code{create_dyadyear()} or
\code{create_stateyear()} function. Make sure that function (or data created by that function) appear at the top
of the proverbial pipe. Users will also want to note that the underlying function access two different data sets. It appears that the
results published in the International Studies Quarterly used Correlates of War classification, but a follow-up repository on Github
uses Gleditsch-Ward classification. The extent to which these estimates are generated by simulation, it does mean the estimates will be slightly
different across both data sets even for common observations (e.g. the United States in 1816). Because these are large nominal numbers, the
estimates have been log-transformed. Users can always exponentiate these if they chose.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_sdp_gdp(system="cow")

create_stateyears() \%>\% add_sdp_gdp(system = "cow")

create_stateyears(system = "gw") \%>\% add_sdp_gdp(system = "gw")


}
\references{
Anders, Therese, Christopher J. Fariss, and Jonathan N. Markowitz. 2020. "Bread Before Guns or Butter: Introducing Surplus Domestic Product (SDP)"
\emph{International Studies Quarterly} 64(2): 392--405.
}
\author{
Steven V. Miller
}
