\name{Context Functions}
\alias{zmq.ctx.new}
\alias{zmq.ctx.destroy}
\title{ Context Functions }
\description{ Context functions }
\usage{
  zmq.ctx.new()
  zmq.ctx.destroy(ctx)
}
\arguments{
  \item{ctx}{a ZMQ context}
}
\details{
  \code{zmq.ctx.new()} initials a ZMQ context for starting communication.

  \code{zmq.ctx.destroy()} terminates the context for stopping communication.
}
\value{
  \code{zmq.ctx.new()} returns an R external pointer (\code{ctx})
  generated by ZMQ C API pointing to a context if successful, otherwise
  returns an R \code{NULL}.

  \code{zmq.ctx.destroy()} returns 0 if successful, otherwise returns -1
  and sets \code{errno} to either \code{EFAULT} or \code{EINTR}.
}
\references{
  ZeroMQ/4.1.0 API Reference:
  \url{http://api.zeromq.org/4-1:_start}

  Programming with Big Data in R Website:
  \url{http://r-pbd.org/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\seealso{
  \code{\link{zmq.socket}()}, \code{\link{zmq.close}()},
  \code{\link{zmq.bind}()}, \code{\link{zmq.connect}()}.
}
\examples{
\dontrun{
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
zmq.ctx.destroy(context)
}
}
\keyword{programming}
