plot_fpmpi <- function(x, ..., which=1L:4L, show.title=TRUE, label)
{
  df <- as.data.frame(x@parsed)
  
  df$Routine <- factor(df$Routine)
  df$Calls <- factor(df$Calls)
  
  if (missing(label))
      label <- "FPMPI Profiler Output"
  
  # Set up plots
  g1 <- ggplot(df, aes_string(x = 'Routine', y = 'Calls')) + 
          geom_bar(stat = "identity", aes_string(fill = 'Routine')) + 
          xlab("Routine") + 
          ylab("Calls") +
          theme(axis.text.x = element_text(angle = 20, hjust = 1)) +
          theme(legend.position = "none")
  
  g2 <- ggplot(df, aes_string(x = 'Routine', y = 'Time')) + 
          geom_bar(stat = "identity", aes_string(fill = 'Routine')) + 
          xlab("Routine") +
          ylab("Time (seconds)") + 
          theme(axis.text.x = element_text(angle = 20, hjust = 1)) +
          theme(legend.position = "none")
  
  g3 <- ggplot(df, aes_string(x = 'Routine', y = 'Data.Sent')) + 
          geom_bar(stat = "identity", aes_string(fill = 'Routine')) + 
          xlab("Routine") +
          ylab("Data Sent (bytes)") + 
          theme(axis.text.x = element_text(angle = 20, hjust = 1)) +
          theme(legend.position = "none")
  
  g4 <- ggplot(df, aes_string(x = 'Routine', y = 'SyncTime')) + 
          geom_bar(stat = "identity", aes_string(fill = 'Routine')) + 
          xlab("Routine") +
          ylab("Sync Time (seconds)") + 
          theme(axis.text.x = element_text(angle = 20, hjust = 1)) +
          theme(legend.position = "none")
  
  # Plot them
  plots <- list(g1, g2, g3, g4)
  
  g <- grid_plotter(plots=plots, which=which, label=label, show.title=show.title)
  
  return( g )
}

