% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_get_restore_testing_inferred_metadata}
\alias{backup_get_restore_testing_inferred_metadata}
\title{This request returns the minimal required set of metadata needed to
start a restore job with secure default settings}
\usage{
backup_get_restore_testing_inferred_metadata(
  BackupVaultAccountId = NULL,
  BackupVaultName,
  RecoveryPointArn
)
}
\arguments{
\item{BackupVaultAccountId}{This is the account ID of the specified backup vault.}

\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the Amazon Web ServicesRegion where they are created. They
consist of letters, numbers, and hyphens.}

\item{RecoveryPointArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
for example,
\verb{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}
}
\description{
This request returns the minimal required set of metadata needed to start a restore job with secure default settings. \code{BackupVaultName} and \code{RecoveryPointArn} are required parameters. \code{BackupVaultAccountId} is an optional parameter.

See \url{https://www.paws-r-sdk.com/docs/backup_get_restore_testing_inferred_metadata/} for full documentation.
}
\keyword{internal}
