% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object}
\alias{s3_put_object}
\title{Adds an object to a bucket}
\usage{
s3_put_object(ACL, Body, Bucket, CacheControl, ContentDisposition,
  ContentEncoding, ContentLanguage, ContentLength, ContentMD5,
  ContentType, Expires, GrantFullControl, GrantRead, GrantReadACP,
  GrantWriteACP, Key, Metadata, ServerSideEncryption, StorageClass,
  WebsiteRedirectLocation, SSECustomerAlgorithm, SSECustomerKey,
  SSECustomerKeyMD5, SSEKMSKeyId, SSEKMSEncryptionContext, RequestPayer,
  Tagging, ObjectLockMode, ObjectLockRetainUntilDate,
  ObjectLockLegalHoldStatus)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL}{Canned ACL}.}

\item{Body}{Object data.}

\item{Bucket}{[required] Bucket name to which the PUT operation was initiated.

When using this API with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this operation using an access point through the AWS SDKs,
you provide the access point ARN in place of the bucket name. For more
information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html}{Using Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{CacheControl}{Can be used to specify caching behavior along the request/reply chain.
For more information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9}.}

\item{ContentDisposition}{Specifies presentational information for the object. For more
information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1}.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field. For more information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11}.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentLength}{Size of the body in bytes. This parameter is useful when the size of the
body cannot be determined automatically. For more information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13}.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the message (without the
headers) according to RFC 1864. This header can be used as a message
integrity check to verify that the data is the same data that was
originally sent. Although it is optional, we recommend using the
Content-MD5 mechanism as an end-to-end integrity check. For more
information about REST request authentication, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html}{REST Authentication}.}

\item{ContentType}{A standard MIME type describing the format of the contents. For more
information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17}.}

\item{Expires}{The date and time at which the object is no longer cacheable. For more
information, see
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21}.}

\item{GrantFullControl}{Gives the grantee READ, READ\\_ACP, and WRITE\\_ACP permissions on the
object.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.}

\item{GrantReadACP}{Allows grantee to read the object ACL.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.}

\item{Key}{[required] Object key for which the PUT operation was initiated.}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{ServerSideEncryption}{The server-side encryption algorithm used when storing this object in
Amazon S3 (for example, AES256, aws:kms).}

\item{StorageClass}{If you don\'t specify, S3 Standard is the default storage class. Amazon
S3 supports other storage classes.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata. For
information about object metadata, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html}{Object Key and Metadata}.

In the following example, the request header sets the redirect to an
object (anotherPage.html) in the same bucket:

\verb{x-amz-website-redirect-location: /anotherPage.html}

In the following example, the request header sets the object redirect to
another website:

\verb{x-amz-website-redirect-location: http://www.example.com/}

For more information about website hosting in Amazon S3, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html}{Hosting Websites on Amazon S3}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html}{How to Configure Website Page Redirects}.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\verb{x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{If \code{x-amz-server-side-encryption} is present and has the value of
\code{aws:kms}, this header specifies the ID of the AWS Key Management
Service (AWS KMS) symmetrical customer managed customer master key (CMK)
that was used for the object.

If the value of \code{x-amz-server-side-encryption} is \code{aws:kms}, this header
specifies the ID of the symmetric customer managed AWS KMS CMK that will
be used for the object. If you specify
\code{x-amz-server-side-encryption:aws:kms}, but do not
provide\code{ x-amz-server-side-encryption-aws-kms-key-id}, Amazon S3 uses
the AWS managed CMK in AWS to protect the data.}

\item{SSEKMSEncryptionContext}{Specifies the AWS KMS Encryption Context to use for object encryption.
The value of this header is a base64-encoded UTF-8 string holding JSON
with the encryption context key-value pairs.}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object. The tag-set must be encoded as URL Query
parameters. (For example, \"Key1=Value1\")}

\item{ObjectLockMode}{The Object Lock mode that you want to apply to this object.}

\item{ObjectLockRetainUntilDate}{The date and time when you want this object\'s Object Lock to expire.}

\item{ObjectLockLegalHoldStatus}{Specifies whether a legal hold will be applied to this object. For more
information about S3 Object Lock, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html}{Object Lock}.}
}
\description{
Adds an object to a bucket. You must have WRITE permissions on a bucket
to add an object to it.
}
\details{
Amazon S3 never adds partial objects; if you receive a success response,
Amazon S3 added the entire object to the bucket.

Amazon S3 is a distributed system. If it receives multiple write
requests for the same object simultaneously, it overwrites all but the
last object written. Amazon S3 does not provide object locking; if you
need this, make sure to build it into your application layer or use
versioning instead.

To ensure that data is not corrupted traversing the network, use the
\code{Content-MD5} header. When you use this header, Amazon S3 checks the
object against the provided MD5 value and, if they do not match, returns
an error. Additionally, you can calculate the MD5 while putting an
object to Amazon S3 and compare the returned ETag to the calculated MD5
value.

The \code{Content-MD5} header is required for any request to upload an object
with a retention period configured using Amazon S3 Object Lock. For more
information about Amazon S3 Object Lock, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html}{Amazon S3 Object Lock Overview}
in the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Server-side Encryption}

You can optionally request server-side encryption. With server-side
encryption, Amazon S3 encrypts your data as it writes it to disks in its
data centers and decrypts the data when you access it. You have the
option to provide your own encryption key or use AWS managed encryption
keys. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html}{Using Server-Side Encryption}.

\strong{Access Control List (ACL)-Specific Request Headers}

You can use headers to grant ACL- based permissions. By default, all
objects are private. Only the owner has full access control. When adding
a new object, you can grant permissions to individual AWS accounts or to
predefined groups defined by Amazon S3. These permissions are then added
to the ACL on the object. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html}{Access Control List (ACL) Overview}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html}{Managing ACLs Using the REST API}.

\strong{Storage Class Options}

By default, Amazon S3 uses the STANDARD storage class to store newly
created objects. The STANDARD storage class provides high durability and
high availability. Depending on performance needs, you can specify a
different storage class. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html}{Storage Classes}
in the \emph{Amazon S3 Service Developer Guide}.

\strong{Versioning}

If you enable versioning for a bucket, Amazon S3 automatically generates
a unique version ID for the object being stored. Amazon S3 returns this
ID in the response. When you enable versioning for a bucket, if Amazon
S3 receives multiple write requests for the same object simultaneously,
it stores all of the objects.

For more information about versioning, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html}{Adding Objects to Versioning Enabled Buckets}.
For information about returning the versioning state of a bucket, see
GetBucketVersioning.

\strong{Related Resources}
\itemize{
\item CopyObject
\item DeleteObject
}
}
\section{Request syntax}{
\preformatted{svc$put_object(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
  Body = raw,
  Bucket = "string",
  CacheControl = "string",
  ContentDisposition = "string",
  ContentEncoding = "string",
  ContentLanguage = "string",
  ContentLength = 123,
  ContentMD5 = "string",
  ContentType = "string",
  Expires = as.POSIXct(
    "2015-01-01"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWriteACP = "string",
  Key = "string",
  Metadata = list(
    "string"
  ),
  ServerSideEncryption = "AES256"|"aws:kms",
  StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
  WebsiteRedirectLocation = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  SSEKMSKeyId = "string",
  SSEKMSEncryptionContext = "string",
  RequestPayer = "requester",
  Tagging = "string",
  ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
  ObjectLockRetainUntilDate = as.POSIXct(
    "2015-01-01"
  ),
  ObjectLockLegalHoldStatus = "ON"|"OFF"
)
}
}

\examples{
\dontrun{
# The following example uploads and object. The request specifies the
# optional server-side encryption option. The request also specifies
# optional object tags. If the bucket is versioning enabled, S3 returns
# version ID in response.
svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject",
  ServerSideEncryption = "AES256",
  Tagging = "key1=value1&key2=value2"
)

# The following example creates an object. If the bucket is versioning
# enabled, S3 returns version ID in response.
svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "objectkey"
)

# The following example uploads an object. The request specifies optional
# object tags. The bucket is versioned, therefore S3 returns version ID of
# the newly created object.
svc$put_object(
  Body = "c:\\\\HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  Tagging = "key1=value1&key2=value2"
)

# The following example uploads an object. The request specifies optional
# request headers to directs S3 to use specific storage class and use
# server-side encryption.
svc$put_object(
  Body = "HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  ServerSideEncryption = "AES256",
  StorageClass = "STANDARD_IA"
)

# The following example creates an object. The request also specifies
# optional metadata. If the bucket is versioning enabled, S3 returns
# version ID in response.
svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject",
  Metadata = list(
    metadata1 = "value1",
    metadata2 = "value2"
  )
)

# The following example uploads and object. The request specifies optional
# canned ACL (access control list) to all READ access to authenticated
# users. If the bucket is versioning enabled, S3 returns version ID in
# response.
svc$put_object(
  ACL = "authenticated-read",
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject"
)

# The following example uploads an object to a versioning-enabled bucket.
# The source file is specified using Windows file syntax. S3 returns
# VersionId of the newly created object.
svc$put_object(
  Body = "HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)
}

}
\keyword{internal}
