% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_gateways}
\alias{storagegateway_list_gateways}
\title{Lists gateways owned by an AWS account in an AWS Region specified in the
request}
\usage{
storagegateway_list_gateways(Marker, Limit)
}
\arguments{
\item{Marker}{An opaque string that indicates the position at which to begin the
returned list of gateways.}

\item{Limit}{Specifies that the list of gateways returned be limited to the specified
number of items.}
}
\description{
Lists gateways owned by an AWS account in an AWS Region specified in the
request. The returned list is ordered by gateway Amazon Resource Name
(ARN).
}
\details{
By default, the operation returns a maximum of 100 gateways. This
operation supports pagination that allows you to optionally reduce the
number of gateways returned in a response.

If you have more gateways than are returned in a response (that is, the
response returns only a truncated list of your gateways), the response
contains a marker that you can specify in your next request to fetch the
next page of gateways.
}
\section{Request syntax}{
\preformatted{svc$list_gateways(
  Marker = "string",
  Limit = 123
)
}
}

\examples{
# Lists gateways owned by an AWS account in a specified region as
# requested. Results are sorted by gateway ARN up to a maximum of 100
# gateways.
\dontrun{svc$list_gateways(
  Limit = 2L,
  Marker = "1"
)}

}
\keyword{internal}
