% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_policy}
\alias{s3_get_bucket_policy}
\title{Returns the policy of a specified bucket}
\usage{
s3_get_bucket_policy(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the bucket policy.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  Policy = "string"
)
}
}
\description{
Returns the policy of a specified bucket. If you are using an identity
other than the root user of the AWS account that owns the bucket, the
calling identity must have the
\code{\link[=s3_get_bucket_policy]{get_bucket_policy}} permissions on the specified
bucket and belong to the bucket owner's account in order to use this
operation.

If you don't have \code{\link[=s3_get_bucket_policy]{get_bucket_policy}}
permissions, Amazon S3 returns a \verb{403 Access Denied} error. If you have
the correct permissions, but you're not using an identity that belongs
to the bucket owner's account, Amazon S3 returns a
\verb{405 Method Not Allowed} error.

As a security precaution, the root user of the AWS account that owns a
bucket can always use this operation, even if the policy explicitly
denies the root user the ability to perform this action.

For more information about bucket policies, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-iam-policies.html}{Using Bucket Policies and User Policies}.

The following operation is related to
\code{\link[=s3_get_bucket_policy]{get_bucket_policy}}:
\itemize{
\item \code{\link[=s3_get_object]{get_object}}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_policy(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example returns bucket policy associated with a bucket.
svc$get_bucket_policy(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
