% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_replication}
\alias{s3_put_bucket_replication}
\title{Creates a replication configuration or replaces an existing one}
\usage{
s3_put_bucket_replication(Bucket, ContentMD5, ReplicationConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{ReplicationConfiguration}{[required]}
}
\description{
Creates a replication configuration or replaces an existing one. For
more information, see Cross-Region Replication (CRR) in the \emph{Amazon S3
Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_replication(
  Bucket = "string",
  ContentMD5 = "string",
  ReplicationConfiguration = list(
    Role = "string",
    Rules = list(
      list(
        ID = "string",
        Priority = 123,
        Prefix = "string",
        Filter = list(
          Prefix = "string",
          Tag = list(
            Key = "string",
            Value = "string"
          ),
          And = list(
            Prefix = "string",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        ),
        Status = "Enabled"|"Disabled",
        SourceSelectionCriteria = list(
          SseKmsEncryptedObjects = list(
            Status = "Enabled"|"Disabled"
          )
        ),
        Destination = list(
          Bucket = "string",
          Account = "string",
          StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
          AccessControlTranslation = list(
            Owner = "Destination"
          ),
          EncryptionConfiguration = list(
            ReplicaKmsKeyID = "string"
          )
        ),
        DeleteMarkerReplication = list(
          Status = "Enabled"|"Disabled"
        )
      )
    )
  )
)
}
}

\examples{
# The following example sets replication configuration on a bucket.
\donttest{svc$put_bucket_replication(
  Bucket = "examplebucket",
  ReplicationConfiguration = list(
    Role = "arn:aws:iam::123456789012:role/examplerole",
    Rules = list(
      list(
        Destination = list(
          Bucket = "arn:aws:s3:::destinationbucket",
          StorageClass = "STANDARD"
        ),
        Prefix = "",
        Status = "Enabled"
      )
    )
  )
)}

}
\keyword{internal}
