% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_backup_job}
\alias{backup_start_backup_job}
\title{Starts a job to create a one-time backup of the specified resource}
\usage{
backup_start_backup_job(BackupVaultName, ResourceArn, IamRoleArn,
  IdempotencyToken, StartWindowMinutes, CompleteWindowMinutes, Lifecycle,
  RecoveryPointTags)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{ResourceArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a resource. The
format of the ARN depends on the resource type.}

\item{IamRoleArn}{[required] Specifies the IAM role ARN used to create the target recovery point; for
example, \code{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer chosen string that can be used to distinguish between calls
to \code{StartBackupJob}. Idempotency tokens time out after one hour.
Therefore, if you call \code{StartBackupJob} multiple times with the same
idempotency token within one hour, AWS Backup recognizes that you are
requesting only one backup job and initiates only one. If you change the
idempotency token for each call, AWS Backup recognizes that you are
requesting to start multiple backups.}

\item{StartWindowMinutes}{The amount of time in minutes before beginning a backup.}

\item{CompleteWindowMinutes}{The amount of time AWS Backup attempts a backup before canceling the job
and returning an error.}

\item{Lifecycle}{The lifecycle defines when a protected resource is transitioned to cold
storage and when it expires. AWS Backup will transition and expire
backups automatically according to the lifecycle that you define.

Backups transitioned to cold storage must be stored in cold storage for
a minimum of 90 days. Therefore, the "expire after days" setting must be
90 days greater than the "transition to cold after days" setting. The
"transition to cold after days" setting cannot be changed after a backup
has been transitioned to cold.}

\item{RecoveryPointTags}{To help organize your resources, you can assign your own metadata to the
resources that you create. Each tag is a key-value pair.}
}
\description{
Starts a job to create a one-time backup of the specified resource.
}
\section{Request syntax}{
\preformatted{svc$start_backup_job(
  BackupVaultName = "string",
  ResourceArn = "string",
  IamRoleArn = "string",
  IdempotencyToken = "string",
  StartWindowMinutes = 123,
  CompleteWindowMinutes = 123,
  Lifecycle = list(
    MoveToColdStorageAfterDays = 123,
    DeleteAfterDays = 123
  ),
  RecoveryPointTags = list(
    "string"
  )
)
}
}

\keyword{internal}
